package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketSendResponse;

/**
 * TOP API: taobao.vmarket.eticket.send request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketSendRequest extends BaseTaobaoRequest<VmarketEticketSendResponse> {
	
	

	/** 
	* 码商ID,是码商的话必须传递,如果是信任卖家,不需要传
	 */
	private Long codemerchantId;

	/** 
	* 订单编号
	 */
	private Long orderId;

	/** 
	* 不需要上传二维码图片的码商请不要传，需要传入二维码的码商请先调用taobao.vmarket.eticket.qrcode.upload接口，将返回的img_filename文件名称作为参数，多个文件名用逗号隔开且与参数verify_codes按从左到有的顺序一一对应。
	 */
	private String qrImages;

	/** 
	* 安全验证token，需要和发码通知中的token一致
	 */
	private String token;

	/** 
	* 发送成功的验证码及可验证次数的列表，码和可验证次数用英文冒号分隔，多个码之间用英文逗号分隔，所有字符都为英文半角
	 */
	private String verifyCodes;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setQrImages(String qrImages) {
		this.qrImages = qrImages;
	}

	public String getQrImages() {
		return this.qrImages;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public void setVerifyCodes(String verifyCodes) {
		this.verifyCodes = verifyCodes;
	}

	public String getVerifyCodes() {
		return this.verifyCodes;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("order_id", this.orderId);
		txtParams.put("qr_images", this.qrImages);
		txtParams.put("token", this.token);
		txtParams.put("verify_codes", this.verifyCodes);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketSendResponse> getResponseClass() {
		return VmarketEticketSendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
		RequestCheckUtils.checkNotEmpty(token, "token");
		RequestCheckUtils.checkNotEmpty(verifyCodes, "verifyCodes");
	}
	

}