package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketTasksGetResponse;

/**
 * TOP API: taobao.vmarket.eticket.tasks.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketTasksGetRequest extends BaseTaobaoRequest<VmarketEticketTasksGetResponse> {
	
	

	/** 
	* 码商ID，如果是码商，必须传，如果是信任卖家，不需要传
	 */
	private Long codemerchantId;

	/** 
	* 页码。取值范围:大于零的整数; 默认值:1
	 */
	private Long pageNo;

	/** 
	* 每页获取条数。默认值40，最小值1，最大值100。
	 */
	private Long pageSize;

	/** 
	* 卖家家ID(信任卖家不必传，码商可选)
	 */
	private Long sellerId;

	/** 
	* 返回结果类型:
1:返回通知失败的订单
2.返回通知成功回调失败的订单
	 */
	private Long type;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Long getSellerId() {
		return this.sellerId;
	}

	public void setType(Long type) {
		this.type = type;
	}

	public Long getType() {
		return this.type;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.tasks.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("seller_id", this.sellerId);
		txtParams.put("type", this.type);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketTasksGetResponse> getResponseClass() {
		return VmarketEticketTasksGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(type, "type");
	}
	

}