package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketTimeExpandResponse;

/**
 * TOP API: taobao.vmarket.eticket.time.expand request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketTimeExpandRequest extends BaseTaobaoRequest<VmarketEticketTimeExpandResponse> {
	
	

	/** 
	* 延长天数，延长时间=当前过期时间+延长天数
	 */
	private Long expandDays;

	/** 
	* 订单ID
	 */
	private Long orderId;

	public void setExpandDays(Long expandDays) {
		this.expandDays = expandDays;
	}

	public Long getExpandDays() {
		return this.expandDays;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.time.expand";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("expand_days", this.expandDays);
		txtParams.put("order_id", this.orderId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketTimeExpandResponse> getResponseClass() {
		return VmarketEticketTimeExpandResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(expandDays, "expandDays");
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
	}
	

}