package com.taobao.api.response;

import java.util.Date;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.fenxiao.refund.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class FenxiaoRefundGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6583355973979484182L;

	/** 
	 * 退款详情
	 */
	@ApiField("refund_detail")
	private RefundDetail refundDetail;


	public void setRefundDetail(RefundDetail refundDetail) {
		this.refundDetail = refundDetail;
	}
	public RefundDetail getRefundDetail( ) {
		return this.refundDetail;
	}
	
	/**
 * 下游买家的退款信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BuyerRefund extends TaobaoObject {

	private static final long serialVersionUID = 7368837719766162496L;

	/**
		 * 订单id
		 */
		@ApiField("biz_order_id")
		private Long bizOrderId;
		/**
		 * 下游买家nick
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 货物的状态：
买家已收到货
买家已退货
买家未收到货
		 */
		@ApiField("goods_status_desc")
		private String goodsStatusDesc;
		/**
		 * 退款修改时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 买家是否退货
		 */
		@ApiField("need_return_goods")
		private Boolean needReturnGoods;
		/**
		 * 退款创建时间
		 */
		@ApiField("refund_create_time")
		private Date refundCreateTime;
		/**
		 * 退款说明
		 */
		@ApiField("refund_desc")
		private String refundDesc;
		/**
		 * 交易退款id
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退款原因
		 */
		@ApiField("refund_reason")
		private String refundReason;
		/**
		 * 退款状态
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 退还买家的金额
		 */
		@ApiField("return_fee")
		private Long returnFee;
		/**
		 * 采购单子单id
		 */
		@ApiField("sub_order_id")
		private Long subOrderId;
		/**
		 * 支付分销商的金额
		 */
		@ApiField("to_seller_fee")
		private Long toSellerFee;
	

	public Long getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(Long bizOrderId) {
			this.bizOrderId = bizOrderId;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getGoodsStatusDesc() {
			return this.goodsStatusDesc;
		}
		public void setGoodsStatusDesc(String goodsStatusDesc) {
			this.goodsStatusDesc = goodsStatusDesc;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public Boolean getNeedReturnGoods() {
			return this.needReturnGoods;
		}
		public void setNeedReturnGoods(Boolean needReturnGoods) {
			this.needReturnGoods = needReturnGoods;
		}
		public Date getRefundCreateTime() {
			return this.refundCreateTime;
		}
		public void setRefundCreateTime(Date refundCreateTime) {
			this.refundCreateTime = refundCreateTime;
		}
		public String getRefundDesc() {
			return this.refundDesc;
		}
		public void setRefundDesc(String refundDesc) {
			this.refundDesc = refundDesc;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public String getRefundReason() {
			return this.refundReason;
		}
		public void setRefundReason(String refundReason) {
			this.refundReason = refundReason;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public Long getReturnFee() {
			return this.returnFee;
		}
		public void setReturnFee(Long returnFee) {
			this.returnFee = returnFee;
		}
		public Long getSubOrderId() {
			return this.subOrderId;
		}
		public void setSubOrderId(Long subOrderId) {
			this.subOrderId = subOrderId;
		}
		public Long getToSellerFee() {
			return this.toSellerFee;
		}
		public void setToSellerFee(Long toSellerFee) {
			this.toSellerFee = toSellerFee;
		}

}

	/**
 * 退款详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RefundDetail extends TaobaoObject {

	private static final long serialVersionUID = 1526273472913287561L;

	/**
		 * 下游买家的退款信息
		 */
		@ApiField("buyer_refund")
		private BuyerRefund buyerRefund;
		/**
		 * 分销商nick
		 */
		@ApiField("distributor_nick")
		private String distributorNick;
		/**
		 * 是否退货
		 */
		@ApiField("is_return_goods")
		private Boolean isReturnGoods;
		/**
		 * 退款修改时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 支付给供应商的金额
		 */
		@ApiField("pay_sup_fee")
		private String paySupFee;
		/**
		 * 主采购单id
		 */
		@ApiField("purchase_order_id")
		private Long purchaseOrderId;
		/**
		 * 退款创建时间
		 */
		@ApiField("refund_create_time")
		private Date refundCreateTime;
		/**
		 * 退款说明
		 */
		@ApiField("refund_desc")
		private String refundDesc;
		/**
		 * 退款的金额
		 */
		@ApiField("refund_fee")
		private String refundFee;
		/**
		 * 退款流程类型：
	4：发货前退款；
	1：发货后退款不退货；
	2：发货后退款退货
		 */
		@ApiField("refund_flow_type")
		private Long refundFlowType;
		/**
		 * 退款原因
		 */
		@ApiField("refund_reason")
		private String refundReason;
		/**
		 * 退款状态
	1：买家已经申请退款，等待卖家同意
	2：卖家已经同意退款，等待买家退货
	3：买家已经退货，等待卖家确认收货
	4：退款关闭
	5：退款成功
	6：卖家拒绝退款
	12：同意退款，待打款
	9：没有申请退款
	10：卖家拒绝确认收货
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 子单id
		 */
		@ApiField("sub_order_id")
		private Long subOrderId;
		/**
		 * 供应商nick
		 */
		@ApiField("supplier_nick")
		private String supplierNick;
		/**
		 * 超时时间
		 */
		@ApiField("timeout")
		private Date timeout;
		/**
		 * 超时类型：
	1：供应商同意退款/同意退货超时；
	2：供应商确认收货超时
		 */
		@ApiField("to_type")
		private Long toType;
	

	public BuyerRefund getBuyerRefund() {
			return this.buyerRefund;
		}
		public void setBuyerRefund(BuyerRefund buyerRefund) {
			this.buyerRefund = buyerRefund;
		}
		public String getDistributorNick() {
			return this.distributorNick;
		}
		public void setDistributorNick(String distributorNick) {
			this.distributorNick = distributorNick;
		}
		public Boolean getIsReturnGoods() {
			return this.isReturnGoods;
		}
		public void setIsReturnGoods(Boolean isReturnGoods) {
			this.isReturnGoods = isReturnGoods;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public String getPaySupFee() {
			return this.paySupFee;
		}
		public void setPaySupFee(String paySupFee) {
			this.paySupFee = paySupFee;
		}
		public Long getPurchaseOrderId() {
			return this.purchaseOrderId;
		}
		public void setPurchaseOrderId(Long purchaseOrderId) {
			this.purchaseOrderId = purchaseOrderId;
		}
		public Date getRefundCreateTime() {
			return this.refundCreateTime;
		}
		public void setRefundCreateTime(Date refundCreateTime) {
			this.refundCreateTime = refundCreateTime;
		}
		public String getRefundDesc() {
			return this.refundDesc;
		}
		public void setRefundDesc(String refundDesc) {
			this.refundDesc = refundDesc;
		}
		public String getRefundFee() {
			return this.refundFee;
		}
		public void setRefundFee(String refundFee) {
			this.refundFee = refundFee;
		}
		public Long getRefundFlowType() {
			return this.refundFlowType;
		}
		public void setRefundFlowType(Long refundFlowType) {
			this.refundFlowType = refundFlowType;
		}
		public String getRefundReason() {
			return this.refundReason;
		}
		public void setRefundReason(String refundReason) {
			this.refundReason = refundReason;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public Long getSubOrderId() {
			return this.subOrderId;
		}
		public void setSubOrderId(Long subOrderId) {
			this.subOrderId = subOrderId;
		}
		public String getSupplierNick() {
			return this.supplierNick;
		}
		public void setSupplierNick(String supplierNick) {
			this.supplierNick = supplierNick;
		}
		public Date getTimeout() {
			return this.timeout;
		}
		public void setTimeout(Date timeout) {
			this.timeout = timeout;
		}
		public Long getToType() {
			return this.toType;
		}
		public void setToType(Long toType) {
			this.toType = toType;
		}

}



}
