package com.taobao.api.response;

import java.util.Date;
import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.channel.products.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallChannelProductsGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8363728139977866268L;

	/** 
	 * 产品对象记录集
	 */
	@ApiListField("products")
	@ApiField("top_product_d_o")
	private List<TopProductDO> products;

	/** 
	 * 查询结果记录数
	 */
	@ApiField("total_results")
	private Long totalResults;


	public void setProducts(List<TopProductDO> products) {
		this.products = products;
	}
	public List<TopProductDO> getProducts( ) {
		return this.products;
	}

	public void setTotalResults(Long totalResults) {
		this.totalResults = totalResults;
	}
	public Long getTotalResults( ) {
		return this.totalResults;
	}
	
	/**
 * 分销产品SKU列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ProductSkuDo extends TaobaoObject {

	private static final long serialVersionUID = 8672829945783554232L;

	/**
		 * 关联的前端宝贝skuid
		 */
		@ApiField("auction_sku_id")
		private Long auctionSkuId;
		/**
		 * 代销采购价:单位分
		 */
		@ApiField("cost_price_fen")
		private Long costPriceFen;
		/**
		 * 商家编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 经销采购价:单位分
		 */
		@ApiField("price_cost_dealer_fen")
		private Long priceCostDealerFen;
		/**
		 * sku的销售属性组合字符串。格式:pid:vid;pid:vid,如:1627207:3232483;1630696:3284570,表示:机身颜色:军绿色;手机套餐:一电一充。
		 */
		@ApiField("properties")
		private String properties;
		/**
		 * 库存
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 配额可用库存
		 */
		@ApiField("quota_quantity")
		private Long quotaQuantity;
		/**
		 * 预扣库存
		 */
		@ApiField("reserved_quantity")
		private Long reservedQuantity;
		/**
		 * 关联的后端商品id
		 */
		@ApiField("scitem_id")
		private Long scitemId;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
		/**
		 * 市场价单位分
		 */
		@ApiField("standard_price_fen")
		private Long standardPriceFen;
	

	public Long getAuctionSkuId() {
			return this.auctionSkuId;
		}
		public void setAuctionSkuId(Long auctionSkuId) {
			this.auctionSkuId = auctionSkuId;
		}
		public Long getCostPriceFen() {
			return this.costPriceFen;
		}
		public void setCostPriceFen(Long costPriceFen) {
			this.costPriceFen = costPriceFen;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public Long getPriceCostDealerFen() {
			return this.priceCostDealerFen;
		}
		public void setPriceCostDealerFen(Long priceCostDealerFen) {
			this.priceCostDealerFen = priceCostDealerFen;
		}
		public String getProperties() {
			return this.properties;
		}
		public void setProperties(String properties) {
			this.properties = properties;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public Long getQuotaQuantity() {
			return this.quotaQuantity;
		}
		public void setQuotaQuantity(Long quotaQuantity) {
			this.quotaQuantity = quotaQuantity;
		}
		public Long getReservedQuantity() {
			return this.reservedQuantity;
		}
		public void setReservedQuantity(Long reservedQuantity) {
			this.reservedQuantity = reservedQuantity;
		}
		public Long getScitemId() {
			return this.scitemId;
		}
		public void setScitemId(Long scitemId) {
			this.scitemId = scitemId;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}
		public Long getStandardPriceFen() {
			return this.standardPriceFen;
		}
		public void setStandardPriceFen(Long standardPriceFen) {
			this.standardPriceFen = standardPriceFen;
		}

}

	/**
 * 产品对象记录集
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopProductDO extends TaobaoObject {

	private static final long serialVersionUID = 4518715734225118148L;

	/**
		 * 关联的前台宝贝id
		 */
		@ApiField("auction_id")
		private Long auctionId;
		/**
		 * 所在地：市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 代销采购价格，单位：元。
		 */
		@ApiField("cost_price_yuan")
		private String costPriceYuan;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private Date created;
		/**
		 * 产品描述路径，通过http请求获取
		 */
		@ApiField("desc_path")
		private String descPath;
		/**
		 * 是否有发票，可选值：false（否）、true（是）
		 */
		@ApiField("have_invoice")
		private Long haveInvoice;
		/**
		 * 是否有保修，可选值：false（否）、true（是）
		 */
		@ApiField("have_quarantee")
		private Long haveQuarantee;
		/**
		 * 下载人数
		 */
		@ApiField("items_count")
		private Long itemsCount;
		/**
		 * 更新时间
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 产品名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 累计采购次数
		 */
		@ApiField("orders_count")
		private Long ordersCount;
		/**
		 * 商家编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 产品图片路径列表，用“,”分隔
		 */
		@ApiField("pictures")
		private String pictures;
		/**
		 * 产品ID
		 */
		@ApiField("pid")
		private Long pid;
		/**
		 * ems费用，单位：元
		 */
		@ApiField("postage_ems")
		private String postageEms;
		/**
		 * 快递费用，单位：元
		 */
		@ApiField("postage_fast")
		private String postageFast;
		/**
		 * 运费模板ID
		 */
		@ApiField("postage_id")
		private Long postageId;
		/**
		 * 平邮费用，单位：元
		 */
		@ApiField("postage_ordinary")
		private String postageOrdinary;
		/**
		 * 运费类型：1（供应商承担运费）、2（分销商承担运费）可选值：seller（供应商承担运费）、buyer（分销商承担运费）
		 */
		@ApiField("postage_type")
		private Long postageType;
		/**
		 * 产品所属产品线id
		 */
		@ApiField("product_line_id")
		private Long productLineId;
		/**
		 * 所在地：省
		 */
		@ApiField("prov")
		private String prov;
		/**
		 * 产品库存
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 最高零售价，单位：元。
		 */
		@ApiField("retail_price_high")
		private String retailPriceHigh;
		/**
		 * 最低零售价，单位：元。
		 */
		@ApiField("retail_price_low")
		private String retailPriceLow;
		/**
		 * scItemId
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
		/**
		 * 分销产品SKU列表
		 */
		@ApiListField("skus")
		@ApiField("product_sku_do")
		private List<ProductSkuDo> skus;
		/**
		 * spuId
		 */
		@ApiField("spu_id")
		private Long spuId;
		/**
		 * 市场价：单位元
		 */
		@ApiField("standard_price")
		private String standardPrice;
		/**
		 * 发布状态： 1 上架，2 下架，3 删除
		 */
		@ApiField("status")
		private Long status;
	

	public Long getAuctionId() {
			return this.auctionId;
		}
		public void setAuctionId(Long auctionId) {
			this.auctionId = auctionId;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getCostPriceYuan() {
			return this.costPriceYuan;
		}
		public void setCostPriceYuan(String costPriceYuan) {
			this.costPriceYuan = costPriceYuan;
		}
		public Date getCreated() {
			return this.created;
		}
		public void setCreated(Date created) {
			this.created = created;
		}
		public String getDescPath() {
			return this.descPath;
		}
		public void setDescPath(String descPath) {
			this.descPath = descPath;
		}
		public Long getHaveInvoice() {
			return this.haveInvoice;
		}
		public void setHaveInvoice(Long haveInvoice) {
			this.haveInvoice = haveInvoice;
		}
		public Long getHaveQuarantee() {
			return this.haveQuarantee;
		}
		public void setHaveQuarantee(Long haveQuarantee) {
			this.haveQuarantee = haveQuarantee;
		}
		public Long getItemsCount() {
			return this.itemsCount;
		}
		public void setItemsCount(Long itemsCount) {
			this.itemsCount = itemsCount;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public Long getOrdersCount() {
			return this.ordersCount;
		}
		public void setOrdersCount(Long ordersCount) {
			this.ordersCount = ordersCount;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public String getPictures() {
			return this.pictures;
		}
		public void setPictures(String pictures) {
			this.pictures = pictures;
		}
		public Long getPid() {
			return this.pid;
		}
		public void setPid(Long pid) {
			this.pid = pid;
		}
		public String getPostageEms() {
			return this.postageEms;
		}
		public void setPostageEms(String postageEms) {
			this.postageEms = postageEms;
		}
		public String getPostageFast() {
			return this.postageFast;
		}
		public void setPostageFast(String postageFast) {
			this.postageFast = postageFast;
		}
		public Long getPostageId() {
			return this.postageId;
		}
		public void setPostageId(Long postageId) {
			this.postageId = postageId;
		}
		public String getPostageOrdinary() {
			return this.postageOrdinary;
		}
		public void setPostageOrdinary(String postageOrdinary) {
			this.postageOrdinary = postageOrdinary;
		}
		public Long getPostageType() {
			return this.postageType;
		}
		public void setPostageType(Long postageType) {
			this.postageType = postageType;
		}
		public Long getProductLineId() {
			return this.productLineId;
		}
		public void setProductLineId(Long productLineId) {
			this.productLineId = productLineId;
		}
		public String getProv() {
			return this.prov;
		}
		public void setProv(String prov) {
			this.prov = prov;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public String getRetailPriceHigh() {
			return this.retailPriceHigh;
		}
		public void setRetailPriceHigh(String retailPriceHigh) {
			this.retailPriceHigh = retailPriceHigh;
		}
		public String getRetailPriceLow() {
			return this.retailPriceLow;
		}
		public void setRetailPriceLow(String retailPriceLow) {
			this.retailPriceLow = retailPriceLow;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}
		public List<ProductSkuDo> getSkus() {
			return this.skus;
		}
		public void setSkus(List<ProductSkuDo> skus) {
			this.skus = skus;
		}
		public Long getSpuId() {
			return this.spuId;
		}
		public void setSpuId(Long spuId) {
			this.spuId = spuId;
		}
		public String getStandardPrice() {
			return this.standardPrice;
		}
		public void setStandardPrice(String standardPrice) {
			this.standardPrice = standardPrice;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}

}



}
