package com.taobao.api.response;

import java.util.Date;
import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.channel.trade.applyorder.gets response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallChannelTradeApplyorderGetsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4553186712456241289L;

	/** 
	 * 包含的元素
	 */
	@ApiListField("page_elements")
	@ApiField("top_channel_apply_order_dto")
	private List<TopChannelApplyOrderDto> pageElements;

	/** 
	 * 查询第几页
	 */
	@ApiField("page_number")
	private Long pageNumber;

	/** 
	 * 每页显示数量
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 所有元素个数
	 */
	@ApiField("total_count")
	private Long totalCount;


	public void setPageElements(List<TopChannelApplyOrderDto> pageElements) {
		this.pageElements = pageElements;
	}
	public List<TopChannelApplyOrderDto> getPageElements( ) {
		return this.pageElements;
	}

	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}
	public Long getPageNumber( ) {
		return this.pageNumber;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}
	
	/**
 * 收货人对应的物流地址详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelLogisticsDto extends TaobaoObject {

	private static final long serialVersionUID = 5232994313769871279L;

	/**
		 * 区对应名称
		 */
		@ApiField("area_name")
		private String areaName;
		/**
		 * 市对应的名称
		 */
		@ApiField("city_name")
		private String cityName;
		/**
		 * 收货地址
		 */
		@ApiField("detail_address")
		private String detailAddress;
		/**
		 * 手机号
		 */
		@ApiField("mobile_phone")
		private String mobilePhone;
		/**
		 * 省对应的名称
		 */
		@ApiField("province_name")
		private String provinceName;
		/**
		 * 收货人全称
		 */
		@ApiField("receiver_full_name")
		private String receiverFullName;
		/**
		 * 完整地址,包含省市区等信息
		 */
		@ApiField("whole_address")
		private String wholeAddress;
	

	public String getAreaName() {
			return this.areaName;
		}
		public void setAreaName(String areaName) {
			this.areaName = areaName;
		}
		public String getCityName() {
			return this.cityName;
		}
		public void setCityName(String cityName) {
			this.cityName = cityName;
		}
		public String getDetailAddress() {
			return this.detailAddress;
		}
		public void setDetailAddress(String detailAddress) {
			this.detailAddress = detailAddress;
		}
		public String getMobilePhone() {
			return this.mobilePhone;
		}
		public void setMobilePhone(String mobilePhone) {
			this.mobilePhone = mobilePhone;
		}
		public String getProvinceName() {
			return this.provinceName;
		}
		public void setProvinceName(String provinceName) {
			this.provinceName = provinceName;
		}
		public String getReceiverFullName() {
			return this.receiverFullName;
		}
		public void setReceiverFullName(String receiverFullName) {
			this.receiverFullName = receiverFullName;
		}
		public String getWholeAddress() {
			return this.wholeAddress;
		}
		public void setWholeAddress(String wholeAddress) {
			this.wholeAddress = wholeAddress;
		}

}

	/**
 * 对应的宝贝详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelApplyOrderRelateItemDto extends TaobaoObject {

	private static final long serialVersionUID = 6793257888883157783L;

	/**
		 * b2c的实付款
		 */
		@ApiField("b2c_actual_pay_fee")
		private Long b2cActualPayFee;
		/**
		 * 购买数量
		 */
		@ApiField("buy_quantity")
		private Long buyQuantity;
		/**
		 * 货品ID
		 */
		@ApiField("product_id")
		private Long productId;
		/**
		 * 货品的skuId
		 */
		@ApiField("product_sku_id")
		private Long productSkuId;
		/**
		 * 采购价
		 */
		@ApiField("purchase_price")
		private Long purchasePrice;
	

	public Long getB2cActualPayFee() {
			return this.b2cActualPayFee;
		}
		public void setB2cActualPayFee(Long b2cActualPayFee) {
			this.b2cActualPayFee = b2cActualPayFee;
		}
		public Long getBuyQuantity() {
			return this.buyQuantity;
		}
		public void setBuyQuantity(Long buyQuantity) {
			this.buyQuantity = buyQuantity;
		}
		public Long getProductId() {
			return this.productId;
		}
		public void setProductId(Long productId) {
			this.productId = productId;
		}
		public Long getProductSkuId() {
			return this.productSkuId;
		}
		public void setProductSkuId(Long productSkuId) {
			this.productSkuId = productSkuId;
		}
		public Long getPurchasePrice() {
			return this.purchasePrice;
		}
		public void setPurchasePrice(Long purchasePrice) {
			this.purchasePrice = purchasePrice;
		}

}

	/**
 * 申请单详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelApplyOrderDetailDto extends TaobaoObject {

	private static final long serialVersionUID = 6545576289413677944L;

	/**
		 * 对应的宝贝详情
		 */
		@ApiListField("apply_order_relate_item_list")
		@ApiField("top_channel_apply_order_relate_item_dto")
		private List<TopChannelApplyOrderRelateItemDto> applyOrderRelateItemList;
		/**
		 * 收货人对应的物流地址详情
		 */
		@ApiField("channel_logistics")
		private TopChannelLogisticsDto channelLogistics;
		/**
		 * 整单价格（包括邮费，分）
		 */
		@ApiField("total_amount")
		private Long totalAmount;
		/**
		 * 整单邮费 （分）
		 */
		@ApiField("total_post_fee")
		private Long totalPostFee;
	

	public List<TopChannelApplyOrderRelateItemDto> getApplyOrderRelateItemList() {
			return this.applyOrderRelateItemList;
		}
		public void setApplyOrderRelateItemList(List<TopChannelApplyOrderRelateItemDto> applyOrderRelateItemList) {
			this.applyOrderRelateItemList = applyOrderRelateItemList;
		}
		public TopChannelLogisticsDto getChannelLogistics() {
			return this.channelLogistics;
		}
		public void setChannelLogistics(TopChannelLogisticsDto channelLogistics) {
			this.channelLogistics = channelLogistics;
		}
		public Long getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(Long totalAmount) {
			this.totalAmount = totalAmount;
		}
		public Long getTotalPostFee() {
			return this.totalPostFee;
		}
		public void setTotalPostFee(Long totalPostFee) {
			this.totalPostFee = totalPostFee;
		}

}

	/**
 * 包含的元素
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelApplyOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 4332216181711954769L;

	/**
		 * 审核创建时间
		 */
		@ApiField("apply_create_time")
		private Date applyCreateTime;
		/**
		 * 申请单详情
		 */
		@ApiField("apply_order_detail")
		private TopChannelApplyOrderDetailDto applyOrderDetail;
		/**
		 * 审核描述
		 */
		@ApiField("audit_desc")
		private String auditDesc;
		/**
		 * 审核状态
		 */
		@ApiField("audit_status")
		private Long auditStatus;
		/**
		 * 撤回的描述
		 */
		@ApiField("cancel_desc")
		private String cancelDesc;
		/**
		 * 渠道
		 */
		@ApiField("channel")
		private Long channel;
		/**
		 * 申请单单号
		 */
		@ApiField("channel_purchase_apply_order_no")
		private String channelPurchaseApplyOrderNo;
		/**
		 * 分销商名称
		 */
		@ApiField("distributor_nick")
		private String distributorNick;
		/**
		 * 申请单状态
		 */
		@ApiField("order_status")
		private Long orderStatus;
		/**
		 * 解析详情
		 */
		@ApiField("schema")
		private String schema;
		/**
		 * 交易类型
		 */
		@ApiField("trade_type")
		private Long tradeType;
	

	public Date getApplyCreateTime() {
			return this.applyCreateTime;
		}
		public void setApplyCreateTime(Date applyCreateTime) {
			this.applyCreateTime = applyCreateTime;
		}
		public TopChannelApplyOrderDetailDto getApplyOrderDetail() {
			return this.applyOrderDetail;
		}
		public void setApplyOrderDetail(TopChannelApplyOrderDetailDto applyOrderDetail) {
			this.applyOrderDetail = applyOrderDetail;
		}
		public String getAuditDesc() {
			return this.auditDesc;
		}
		public void setAuditDesc(String auditDesc) {
			this.auditDesc = auditDesc;
		}
		public Long getAuditStatus() {
			return this.auditStatus;
		}
		public void setAuditStatus(Long auditStatus) {
			this.auditStatus = auditStatus;
		}
		public String getCancelDesc() {
			return this.cancelDesc;
		}
		public void setCancelDesc(String cancelDesc) {
			this.cancelDesc = cancelDesc;
		}
		public Long getChannel() {
			return this.channel;
		}
		public void setChannel(Long channel) {
			this.channel = channel;
		}
		public String getChannelPurchaseApplyOrderNo() {
			return this.channelPurchaseApplyOrderNo;
		}
		public void setChannelPurchaseApplyOrderNo(String channelPurchaseApplyOrderNo) {
			this.channelPurchaseApplyOrderNo = channelPurchaseApplyOrderNo;
		}
		public String getDistributorNick() {
			return this.distributorNick;
		}
		public void setDistributorNick(String distributorNick) {
			this.distributorNick = distributorNick;
		}
		public Long getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(Long orderStatus) {
			this.orderStatus = orderStatus;
		}
		public String getSchema() {
			return this.schema;
		}
		public void setSchema(String schema) {
			this.schema = schema;
		}
		public Long getTradeType() {
			return this.tradeType;
		}
		public void setTradeType(Long tradeType) {
			this.tradeType = tradeType;
		}

}



}
