package com.taobao.api.response;

import java.util.Date;
import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.channel.trade.deliverorder.gets response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallChannelTradeDeliverorderGetsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1793667717429458528L;

	/** 
	 * 此页中包含的元素
	 */
	@ApiListField("page_elements")
	@ApiField("top_channel_deliver_order_dto")
	private List<TopChannelDeliverOrderDto> pageElements;

	/** 
	 * 查询第几页
	 */
	@ApiField("page_number")
	private Long pageNumber;

	/** 
	 * 每页显示数量
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 所有元素个数
	 */
	@ApiField("total_count")
	private Long totalCount;


	public void setPageElements(List<TopChannelDeliverOrderDto> pageElements) {
		this.pageElements = pageElements;
	}
	public List<TopChannelDeliverOrderDto> getPageElements( ) {
		return this.pageElements;
	}

	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}
	public Long getPageNumber( ) {
		return this.pageNumber;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}
	
	/**
 * 子发货单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelSubDeliverOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 4157131889369145152L;

	/**
		 * 发货数量
		 */
		@ApiField("deliver_count")
		private Long deliverCount;
		/**
		 * 差异数量
		 */
		@ApiField("diff_quantity")
		private Long diffQuantity;
		/**
		 * 主发货单单号
		 */
		@ApiField("main_deliver_order_no")
		private Long mainDeliverOrderNo;
		/**
		 * 主采购单号
		 */
		@ApiField("main_purchase_order_no")
		private Long mainPurchaseOrderNo;
		/**
		 * 实收数量
		 */
		@ApiField("receive_quantity")
		private Long receiveQuantity;
		/**
		 * 子发货单单号
		 */
		@ApiField("sub_deliver_order_no")
		private Long subDeliverOrderNo;
		/**
		 * 子采购单单号
		 */
		@ApiField("sub_purchase_order_no")
		private Long subPurchaseOrderNo;
	

	public Long getDeliverCount() {
			return this.deliverCount;
		}
		public void setDeliverCount(Long deliverCount) {
			this.deliverCount = deliverCount;
		}
		public Long getDiffQuantity() {
			return this.diffQuantity;
		}
		public void setDiffQuantity(Long diffQuantity) {
			this.diffQuantity = diffQuantity;
		}
		public Long getMainDeliverOrderNo() {
			return this.mainDeliverOrderNo;
		}
		public void setMainDeliverOrderNo(Long mainDeliverOrderNo) {
			this.mainDeliverOrderNo = mainDeliverOrderNo;
		}
		public Long getMainPurchaseOrderNo() {
			return this.mainPurchaseOrderNo;
		}
		public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
			this.mainPurchaseOrderNo = mainPurchaseOrderNo;
		}
		public Long getReceiveQuantity() {
			return this.receiveQuantity;
		}
		public void setReceiveQuantity(Long receiveQuantity) {
			this.receiveQuantity = receiveQuantity;
		}
		public Long getSubDeliverOrderNo() {
			return this.subDeliverOrderNo;
		}
		public void setSubDeliverOrderNo(Long subDeliverOrderNo) {
			this.subDeliverOrderNo = subDeliverOrderNo;
		}
		public Long getSubPurchaseOrderNo() {
			return this.subPurchaseOrderNo;
		}
		public void setSubPurchaseOrderNo(Long subPurchaseOrderNo) {
			this.subPurchaseOrderNo = subPurchaseOrderNo;
		}

}

	/**
 * 物流单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelLogisticsOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 2597762842638495238L;

	/**
		 * 物流公司编号
		 */
		@ApiField("logistics_company_code")
		private String logisticsCompanyCode;
		/**
		 * 物流公司名称
		 */
		@ApiField("logistics_company_name")
		private String logisticsCompanyName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_order_no")
		private String logisticsOrderNo;
	

	public String getLogisticsCompanyCode() {
			return this.logisticsCompanyCode;
		}
		public void setLogisticsCompanyCode(String logisticsCompanyCode) {
			this.logisticsCompanyCode = logisticsCompanyCode;
		}
		public String getLogisticsCompanyName() {
			return this.logisticsCompanyName;
		}
		public void setLogisticsCompanyName(String logisticsCompanyName) {
			this.logisticsCompanyName = logisticsCompanyName;
		}
		public String getLogisticsOrderNo() {
			return this.logisticsOrderNo;
		}
		public void setLogisticsOrderNo(String logisticsOrderNo) {
			this.logisticsOrderNo = logisticsOrderNo;
		}

}

	/**
 * 此页中包含的元素
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelDeliverOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 7421498513188681615L;

	/**
		 * 审核状态
		 */
		@ApiField("audit_status")
		private Long auditStatus;
		/**
		 * 渠道
		 */
		@ApiField("channel")
		private Long channel;
		/**
		 * 分销商Nick
		 */
		@ApiField("distributor_nick")
		private String distributorNick;
		/**
		 * 物流单列表
		 */
		@ApiListField("logistics_order_list")
		@ApiField("top_channel_logistics_order_dto")
		private List<TopChannelLogisticsOrderDto> logisticsOrderList;
		/**
		 * 发货单单号
		 */
		@ApiField("main_deliver_order_no")
		private Long mainDeliverOrderNo;
		/**
		 * 创建时间
		 */
		@ApiField("order_create_time")
		private Date orderCreateTime;
		/**
		 * 最后更新时间
		 */
		@ApiField("order_last_modify_time")
		private Date orderLastModifyTime;
		/**
		 * 发货单状态
		 */
		@ApiField("order_status")
		private Long orderStatus;
		/**
		 * 解析详情
		 */
		@ApiField("schema")
		private String schema;
		/**
		 * 子发货单列表
		 */
		@ApiListField("sub_deliver_order_list")
		@ApiField("top_channel_sub_deliver_order_dto")
		private List<TopChannelSubDeliverOrderDto> subDeliverOrderList;
	

	public Long getAuditStatus() {
			return this.auditStatus;
		}
		public void setAuditStatus(Long auditStatus) {
			this.auditStatus = auditStatus;
		}
		public Long getChannel() {
			return this.channel;
		}
		public void setChannel(Long channel) {
			this.channel = channel;
		}
		public String getDistributorNick() {
			return this.distributorNick;
		}
		public void setDistributorNick(String distributorNick) {
			this.distributorNick = distributorNick;
		}
		public List<TopChannelLogisticsOrderDto> getLogisticsOrderList() {
			return this.logisticsOrderList;
		}
		public void setLogisticsOrderList(List<TopChannelLogisticsOrderDto> logisticsOrderList) {
			this.logisticsOrderList = logisticsOrderList;
		}
		public Long getMainDeliverOrderNo() {
			return this.mainDeliverOrderNo;
		}
		public void setMainDeliverOrderNo(Long mainDeliverOrderNo) {
			this.mainDeliverOrderNo = mainDeliverOrderNo;
		}
		public Date getOrderCreateTime() {
			return this.orderCreateTime;
		}
		public void setOrderCreateTime(Date orderCreateTime) {
			this.orderCreateTime = orderCreateTime;
		}
		public Date getOrderLastModifyTime() {
			return this.orderLastModifyTime;
		}
		public void setOrderLastModifyTime(Date orderLastModifyTime) {
			this.orderLastModifyTime = orderLastModifyTime;
		}
		public Long getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(Long orderStatus) {
			this.orderStatus = orderStatus;
		}
		public String getSchema() {
			return this.schema;
		}
		public void setSchema(String schema) {
			this.schema = schema;
		}
		public List<TopChannelSubDeliverOrderDto> getSubDeliverOrderList() {
			return this.subDeliverOrderList;
		}
		public void setSubDeliverOrderList(List<TopChannelSubDeliverOrderDto> subDeliverOrderList) {
			this.subDeliverOrderList = subDeliverOrderList;
		}

}



}
