package com.taobao.api.response;

import java.util.Date;
import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.channel.trade.order.gets response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallChannelTradeOrderGetsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5112293279934114573L;

	/** 
	 * 此页中包含的元素
	 */
	@ApiListField("page_elements")
	@ApiField("top_channel_purchase_order_dto")
	private List<TopChannelPurchaseOrderDto> pageElements;

	/** 
	 * 查询第几页
	 */
	@ApiField("page_number")
	private Long pageNumber;

	/** 
	 * 每页显示数量
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 所有元素个数
	 */
	@ApiField("total_count")
	private Long totalCount;


	public void setPageElements(List<TopChannelPurchaseOrderDto> pageElements) {
		this.pageElements = pageElements;
	}
	public List<TopChannelPurchaseOrderDto> getPageElements( ) {
		return this.pageElements;
	}

	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}
	public Long getPageNumber( ) {
		return this.pageNumber;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}
	
	/**
 * 子采购单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelSubPurchaseOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 1363718184626819251L;

	/**
		 * 购买数量
		 */
		@ApiField("buy_amount")
		private Long buyAmount;
		/**
		 * 交易完成时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 子采购单的物流状态
		 */
		@ApiField("logistics_status")
		private Long logisticsStatus;
		/**
		 * 商家编码
		 */
		@ApiField("merchant_code")
		private String merchantCode;
		/**
		 * 支付状态
		 */
		@ApiField("pay_status")
		private Long payStatus;
		/**
		 * 产品id
		 */
		@ApiField("product_id")
		private Long productId;
		/**
		 * 产品编码
		 */
		@ApiField("product_number")
		private String productNumber;
		/**
		 * 产品价格
		 */
		@ApiField("product_price")
		private Long productPrice;
		/**
		 * 产品标题
		 */
		@ApiField("product_title")
		private String productTitle;
		/**
		 * sku信息
		 */
		@ApiField("sku")
		private String sku;
		/**
		 * 子采购单单号
		 */
		@ApiField("sub_purchase_order_no")
		private Long subPurchaseOrderNo;
	

	public Long getBuyAmount() {
			return this.buyAmount;
		}
		public void setBuyAmount(Long buyAmount) {
			this.buyAmount = buyAmount;
		}
		public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public Long getLogisticsStatus() {
			return this.logisticsStatus;
		}
		public void setLogisticsStatus(Long logisticsStatus) {
			this.logisticsStatus = logisticsStatus;
		}
		public String getMerchantCode() {
			return this.merchantCode;
		}
		public void setMerchantCode(String merchantCode) {
			this.merchantCode = merchantCode;
		}
		public Long getPayStatus() {
			return this.payStatus;
		}
		public void setPayStatus(Long payStatus) {
			this.payStatus = payStatus;
		}
		public Long getProductId() {
			return this.productId;
		}
		public void setProductId(Long productId) {
			this.productId = productId;
		}
		public String getProductNumber() {
			return this.productNumber;
		}
		public void setProductNumber(String productNumber) {
			this.productNumber = productNumber;
		}
		public Long getProductPrice() {
			return this.productPrice;
		}
		public void setProductPrice(Long productPrice) {
			this.productPrice = productPrice;
		}
		public String getProductTitle() {
			return this.productTitle;
		}
		public void setProductTitle(String productTitle) {
			this.productTitle = productTitle;
		}
		public String getSku() {
			return this.sku;
		}
		public void setSku(String sku) {
			this.sku = sku;
		}
		public Long getSubPurchaseOrderNo() {
			return this.subPurchaseOrderNo;
		}
		public void setSubPurchaseOrderNo(Long subPurchaseOrderNo) {
			this.subPurchaseOrderNo = subPurchaseOrderNo;
		}

}

	/**
 * 物流地址信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelLogisticsDto extends TaobaoObject {

	private static final long serialVersionUID = 4867567411246167686L;

	/**
		 * 区对应名称
		 */
		@ApiField("area_name")
		private String areaName;
		/**
		 * 市对应的名称
		 */
		@ApiField("city_name")
		private String cityName;
		/**
		 * 收货地址
		 */
		@ApiField("detail_address")
		private String detailAddress;
		/**
		 * 手机号
		 */
		@ApiField("mobile_phone")
		private String mobilePhone;
		/**
		 * 省对应的名称
		 */
		@ApiField("province_name")
		private String provinceName;
		/**
		 * 收货人全称
		 */
		@ApiField("receiver_full_name")
		private String receiverFullName;
		/**
		 * 完整地址,包含省市区等信息
		 */
		@ApiField("whole_address")
		private String wholeAddress;
	

	public String getAreaName() {
			return this.areaName;
		}
		public void setAreaName(String areaName) {
			this.areaName = areaName;
		}
		public String getCityName() {
			return this.cityName;
		}
		public void setCityName(String cityName) {
			this.cityName = cityName;
		}
		public String getDetailAddress() {
			return this.detailAddress;
		}
		public void setDetailAddress(String detailAddress) {
			this.detailAddress = detailAddress;
		}
		public String getMobilePhone() {
			return this.mobilePhone;
		}
		public void setMobilePhone(String mobilePhone) {
			this.mobilePhone = mobilePhone;
		}
		public String getProvinceName() {
			return this.provinceName;
		}
		public void setProvinceName(String provinceName) {
			this.provinceName = provinceName;
		}
		public String getReceiverFullName() {
			return this.receiverFullName;
		}
		public void setReceiverFullName(String receiverFullName) {
			this.receiverFullName = receiverFullName;
		}
		public String getWholeAddress() {
			return this.wholeAddress;
		}
		public void setWholeAddress(String wholeAddress) {
			this.wholeAddress = wholeAddress;
		}

}

	/**
 * 物流单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelLogisticsOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 2889116547569742754L;

	/**
		 * 物流公司编号
		 */
		@ApiField("logistics_company_code")
		private String logisticsCompanyCode;
		/**
		 * 物流公司名称
		 */
		@ApiField("logistics_company_name")
		private String logisticsCompanyName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_order_no")
		private String logisticsOrderNo;
	

	public String getLogisticsCompanyCode() {
			return this.logisticsCompanyCode;
		}
		public void setLogisticsCompanyCode(String logisticsCompanyCode) {
			this.logisticsCompanyCode = logisticsCompanyCode;
		}
		public String getLogisticsCompanyName() {
			return this.logisticsCompanyName;
		}
		public void setLogisticsCompanyName(String logisticsCompanyName) {
			this.logisticsCompanyName = logisticsCompanyName;
		}
		public String getLogisticsOrderNo() {
			return this.logisticsOrderNo;
		}
		public void setLogisticsOrderNo(String logisticsOrderNo) {
			this.logisticsOrderNo = logisticsOrderNo;
		}

}

	/**
 * 此页中包含的元素
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelPurchaseOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 4843592249847935217L;

	/**
		 * 收货人名字
		 */
		@ApiField("buyer_fullname")
		private String buyerFullname;
		/**
		 * 买家淘宝nick
		 */
		@ApiField("buyer_taobao_nick")
		private String buyerTaobaoNick;
		/**
		 * 渠道编码
		 */
		@ApiField("channel")
		private Long channel;
		/**
		 * 物流地址信息
		 */
		@ApiField("channel_logistics")
		private TopChannelLogisticsDto channelLogistics;
		/**
		 * 物流单信息
		 */
		@ApiField("channel_logistics_order")
		private TopChannelLogisticsOrderDto channelLogisticsOrder;
		/**
		 * 申请单单号
		 */
		@ApiField("channel_purchase_apply_order_no")
		private String channelPurchaseApplyOrderNo;
		/**
		 * 记录创建时间
		 */
		@ApiField("create_time")
		private Date createTime;
		/**
		 * 分销商淘宝nick
		 */
		@ApiField("distributor_nick")
		private String distributorNick;
		/**
		 * 主采购单物流状态
		 */
		@ApiField("logistics_status")
		private Long logisticsStatus;
		/**
		 * 主采购单号
		 */
		@ApiField("main_purchase_order_no")
		private Long mainPurchaseOrderNo;
		/**
		 * 记录修改时间
		 */
		@ApiField("modified_time")
		private Date modifiedTime;
		/**
		 * 交易状态
		 */
		@ApiField("order_status")
		private Long orderStatus;
		/**
		 * 主采购单支付状态
		 */
		@ApiField("pay_status")
		private Long payStatus;
		/**
		 * 付款时间
		 */
		@ApiField("pay_time")
		private Date payTime;
		/**
		 * 付款类型
		 */
		@ApiField("pay_type")
		private Long payType;
		/**
		 * 改价后的最新邮费
		 */
		@ApiField("post_fee")
		private Long postFee;
		/**
		 * 解析详情
		 */
		@ApiField("schema")
		private String schema;
		/**
		 * 子采购单列表
		 */
		@ApiListField("sub_order_list")
		@ApiField("top_channel_sub_purchase_order_dto")
		private List<TopChannelSubPurchaseOrderDto> subOrderList;
		/**
		 * 交易类型
		 */
		@ApiField("trade_type")
		private Long tradeType;
	

	public String getBuyerFullname() {
			return this.buyerFullname;
		}
		public void setBuyerFullname(String buyerFullname) {
			this.buyerFullname = buyerFullname;
		}
		public String getBuyerTaobaoNick() {
			return this.buyerTaobaoNick;
		}
		public void setBuyerTaobaoNick(String buyerTaobaoNick) {
			this.buyerTaobaoNick = buyerTaobaoNick;
		}
		public Long getChannel() {
			return this.channel;
		}
		public void setChannel(Long channel) {
			this.channel = channel;
		}
		public TopChannelLogisticsDto getChannelLogistics() {
			return this.channelLogistics;
		}
		public void setChannelLogistics(TopChannelLogisticsDto channelLogistics) {
			this.channelLogistics = channelLogistics;
		}
		public TopChannelLogisticsOrderDto getChannelLogisticsOrder() {
			return this.channelLogisticsOrder;
		}
		public void setChannelLogisticsOrder(TopChannelLogisticsOrderDto channelLogisticsOrder) {
			this.channelLogisticsOrder = channelLogisticsOrder;
		}
		public String getChannelPurchaseApplyOrderNo() {
			return this.channelPurchaseApplyOrderNo;
		}
		public void setChannelPurchaseApplyOrderNo(String channelPurchaseApplyOrderNo) {
			this.channelPurchaseApplyOrderNo = channelPurchaseApplyOrderNo;
		}
		public Date getCreateTime() {
			return this.createTime;
		}
		public void setCreateTime(Date createTime) {
			this.createTime = createTime;
		}
		public String getDistributorNick() {
			return this.distributorNick;
		}
		public void setDistributorNick(String distributorNick) {
			this.distributorNick = distributorNick;
		}
		public Long getLogisticsStatus() {
			return this.logisticsStatus;
		}
		public void setLogisticsStatus(Long logisticsStatus) {
			this.logisticsStatus = logisticsStatus;
		}
		public Long getMainPurchaseOrderNo() {
			return this.mainPurchaseOrderNo;
		}
		public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
			this.mainPurchaseOrderNo = mainPurchaseOrderNo;
		}
		public Date getModifiedTime() {
			return this.modifiedTime;
		}
		public void setModifiedTime(Date modifiedTime) {
			this.modifiedTime = modifiedTime;
		}
		public Long getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(Long orderStatus) {
			this.orderStatus = orderStatus;
		}
		public Long getPayStatus() {
			return this.payStatus;
		}
		public void setPayStatus(Long payStatus) {
			this.payStatus = payStatus;
		}
		public Date getPayTime() {
			return this.payTime;
		}
		public void setPayTime(Date payTime) {
			this.payTime = payTime;
		}
		public Long getPayType() {
			return this.payType;
		}
		public void setPayType(Long payType) {
			this.payType = payType;
		}
		public Long getPostFee() {
			return this.postFee;
		}
		public void setPostFee(Long postFee) {
			this.postFee = postFee;
		}
		public String getSchema() {
			return this.schema;
		}
		public void setSchema(String schema) {
			this.schema = schema;
		}
		public List<TopChannelSubPurchaseOrderDto> getSubOrderList() {
			return this.subOrderList;
		}
		public void setSubOrderList(List<TopChannelSubPurchaseOrderDto> subOrderList) {
			this.subOrderList = subOrderList;
		}
		public Long getTradeType() {
			return this.tradeType;
		}
		public void setTradeType(Long tradeType) {
			this.tradeType = tradeType;
		}

}



}
