package com.taobao.api.response;

import com.taobao.api.internal.mapping.ApiField;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.vmarket.eticket.consume response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class VmarketEticketConsumeResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8661972983868612835L;

	/** 
	 * 该核销码在核销后剩余的可核销份数，如果传了new_code来重新生成码，那么这些可核销份数会累积到新的码上
	 */
	@ApiField("code_left_num")
	private Long codeLeftNum;

	/** 
	 * 核销流水号,可以通过该流水号来撤销对应的核销操作
	 */
	@ApiField("consume_secial_num")
	private String consumeSecialNum;

	/** 
	 * 宝贝标题
	 */
	@ApiField("item_title")
	private String itemTitle;

	/** 
	 * 整个订单剩余的可核销数量
	 */
	@ApiField("left_num")
	private Long leftNum;

	/** 
	 * 服务内容，用在凭证验证成功后pos机打印小票给消费者
	 */
	@ApiField("print_tpl")
	private String printTpl;

	/** 
	 * 0:失败，1:成功
	 */
	@ApiField("ret_code")
	private Long retCode;

	/** 
	 * 返回码消费后，需要发送的短信的模版
	 */
	@ApiField("sms_tpl")
	private String smsTpl;


	public void setCodeLeftNum(Long codeLeftNum) {
		this.codeLeftNum = codeLeftNum;
	}
	public Long getCodeLeftNum( ) {
		return this.codeLeftNum;
	}

	public void setConsumeSecialNum(String consumeSecialNum) {
		this.consumeSecialNum = consumeSecialNum;
	}
	public String getConsumeSecialNum( ) {
		return this.consumeSecialNum;
	}

	public void setItemTitle(String itemTitle) {
		this.itemTitle = itemTitle;
	}
	public String getItemTitle( ) {
		return this.itemTitle;
	}

	public void setLeftNum(Long leftNum) {
		this.leftNum = leftNum;
	}
	public Long getLeftNum( ) {
		return this.leftNum;
	}

	public void setPrintTpl(String printTpl) {
		this.printTpl = printTpl;
	}
	public String getPrintTpl( ) {
		return this.printTpl;
	}

	public void setRetCode(Long retCode) {
		this.retCode = retCode;
	}
	public Long getRetCode( ) {
		return this.retCode;
	}

	public void setSmsTpl(String smsTpl) {
		this.smsTpl = smsTpl;
	}
	public String getSmsTpl( ) {
		return this.smsTpl;
	}
	


}
