/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallChannelTradeDeliverorderShipResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmallChannelTradeDeliverorderShipRequest
extends BaseTaobaoRequest<TmallChannelTradeDeliverorderShipResponse> {
    private Long channel;
    private String distributorNick;
    private String logisticsOrderList;
    private String requestNo;
    private String subDeliverOrderCreateList;

    public void setChannel(Long channel) {
        this.channel = channel;
    }

    public Long getChannel() {
        return this.channel;
    }

    public void setDistributorNick(String distributorNick) {
        this.distributorNick = distributorNick;
    }

    public String getDistributorNick() {
        return this.distributorNick;
    }

    public void setLogisticsOrderList(String logisticsOrderList) {
        this.logisticsOrderList = logisticsOrderList;
    }

    public void setLogisticsOrderList(List<TopChannelLogisticsOrderDto> logisticsOrderList) {
        this.logisticsOrderList = new JSONWriter(false, true).write(logisticsOrderList);
    }

    public String getLogisticsOrderList() {
        return this.logisticsOrderList;
    }

    public void setRequestNo(String requestNo) {
        this.requestNo = requestNo;
    }

    public String getRequestNo() {
        return this.requestNo;
    }

    public void setSubDeliverOrderCreateList(String subDeliverOrderCreateList) {
        this.subDeliverOrderCreateList = subDeliverOrderCreateList;
    }

    public void setSubDeliverOrderCreateList(List<TopChannelSubDeliverOrderCreateDto> subDeliverOrderCreateList) {
        this.subDeliverOrderCreateList = new JSONWriter(false, true).write(subDeliverOrderCreateList);
    }

    public String getSubDeliverOrderCreateList() {
        return this.subDeliverOrderCreateList;
    }

    @Override
    public String getApiMethodName() {
        return "tmall.channel.trade.deliverorder.ship";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("channel", (Object)this.channel);
        txtParams.put("distributor_nick", this.distributorNick);
        txtParams.put("logistics_order_list", this.logisticsOrderList);
        txtParams.put("request_no", this.requestNo);
        txtParams.put("sub_deliver_order_create_list", this.subDeliverOrderCreateList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TmallChannelTradeDeliverorderShipResponse> getResponseClass() {
        return TmallChannelTradeDeliverorderShipResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.channel, "channel");
        RequestCheckUtils.checkNotEmpty(this.distributorNick, "distributorNick");
        RequestCheckUtils.checkObjectMaxListSize(this.logisticsOrderList, 20, "logisticsOrderList");
        RequestCheckUtils.checkNotEmpty(this.requestNo, "requestNo");
        RequestCheckUtils.checkObjectMaxListSize(this.subDeliverOrderCreateList, 20, "subDeliverOrderCreateList");
    }

    public static class TopChannelLogisticsOrderDto
    extends TaobaoObject {
        private static final long serialVersionUID = 2165388334151883483L;
        @ApiField(value="logistics_company_code")
        private String logisticsCompanyCode;
        @ApiField(value="logistics_company_name")
        private String logisticsCompanyName;
        @ApiField(value="logistics_order_no")
        private String logisticsOrderNo;

        public String getLogisticsCompanyCode() {
            return this.logisticsCompanyCode;
        }

        public void setLogisticsCompanyCode(String logisticsCompanyCode) {
            this.logisticsCompanyCode = logisticsCompanyCode;
        }

        public String getLogisticsCompanyName() {
            return this.logisticsCompanyName;
        }

        public void setLogisticsCompanyName(String logisticsCompanyName) {
            this.logisticsCompanyName = logisticsCompanyName;
        }

        public String getLogisticsOrderNo() {
            return this.logisticsOrderNo;
        }

        public void setLogisticsOrderNo(String logisticsOrderNo) {
            this.logisticsOrderNo = logisticsOrderNo;
        }
    }

    public static class TopChannelSubDeliverOrderCreateDto
    extends TaobaoObject {
        private static final long serialVersionUID = 4177814633797133527L;
        @ApiField(value="deliver_count")
        private Long deliverCount;
        @ApiField(value="main_purchase_order_no")
        private Long mainPurchaseOrderNo;
        @ApiField(value="sub_purchase_order_no")
        private Long subPurchaseOrderNo;

        public Long getDeliverCount() {
            return this.deliverCount;
        }

        public void setDeliverCount(Long deliverCount) {
            this.deliverCount = deliverCount;
        }

        public Long getMainPurchaseOrderNo() {
            return this.mainPurchaseOrderNo;
        }

        public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
            this.mainPurchaseOrderNo = mainPurchaseOrderNo;
        }

        public Long getSubPurchaseOrderNo() {
            return this.subPurchaseOrderNo;
        }

        public void setSubPurchaseOrderNo(Long subPurchaseOrderNo) {
            this.subPurchaseOrderNo = subPurchaseOrderNo;
        }
    }
}

