/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.aliyun.api.internal.mapping.RequestBodyConverter;
import com.qimen.api.QimenRequest;
import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoParser;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.dto.RequestDTO;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.HttpResponseData;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import com.taobao.api.internal.util.WebV2Utils;
import com.taobao.api.internal.util.XmlWriter;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaobaoClient
implements TaobaoClient {
    protected String serverUrl;
    protected String appKey;
    protected String appSecret;
    protected String format = "json";
    protected String signMethod = "hmac-sha256";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useSimplifyJson = false;
    protected boolean useGzipEncoding = true;
    private boolean isHttpDnsEnabled = false;
    private String originalHttpHost = null;
    private String version = "2.0";
    private boolean enableApiReporter = false;
    private Proxy proxy;

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        return this._execute(request, session);
    }

    private <T extends TaobaoResponse> T _execute(TaobaoRequest<T> request, String session) throws ApiException {
        long start = System.currentTimeMillis();
        TaobaoParser<T> parser = this.buildParser(request);
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                TaobaoResponse localResponse = null;
                try {
                    localResponse = (TaobaoResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder requestHolder = this.invokeApi(request, session, start);
        T tRsp = this.parseBody(parser, request, requestHolder);
        ((TaobaoResponse)tRsp).setParams(requestHolder.getApplicationParams());
        if (!((TaobaoResponse)tRsp).isSuccess()) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, ((TaobaoResponse)tRsp).getBody());
        }
        return tRsp;
    }

    public String getServerUrl(String serverUrl, String apiName, String session, TaobaoHashMap appParams) {
        if (this.isHttpDnsEnabled) {
            DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
            if (dnsConfig == null) {
                return serverUrl;
            }
            return dnsConfig.getVipUrl(serverUrl);
        }
        return serverUrl;
    }

    public String getSdkVersion() {
        if (this.isHttpDnsEnabled) {
            return "top-sdk-java-httpdns-20221020";
        }
        return "top-sdk-java-20221020";
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setUseSimplifyJson(boolean useSimplifyJson) {
        this.useSimplifyJson = useSimplifyJson;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getTopHttpDnsHost() {
        if (this.isHttpDnsEnabled) {
            return this.originalHttpHost;
        }
        return null;
    }

    public void enableHttpDns() {
        WebUtils.setIgnoreHostCheck(true);
        this.setHttpDnsHost(this.serverUrl);
        ClusterManager.initRefreshThread(this.appKey, this.appSecret);
        this.isHttpDnsEnabled = true;
    }

    public void enableHttpDns(String onlineAppKey, String onlineAppSecret) {
        WebUtils.setIgnoreHostCheck(true);
        this.setHttpDnsHost(this.serverUrl);
        ClusterManager.initRefreshThread(onlineAppKey, onlineAppSecret);
        this.isHttpDnsEnabled = true;
    }

    public void resetServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRequestUrl() {
        return this.serverUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    private void setHttpDnsHost(String serverUrl) {
        if (serverUrl == null) {
            return;
        }
        try {
            URL url = new URL(serverUrl);
            this.originalHttpHost = url.getHost();
        }
        catch (Exception e) {
            throw new RuntimeException("error serverUrl:" + serverUrl, e);
        }
    }

    private <T extends TaobaoResponse> TaobaoParser<T> buildParser(TaobaoRequest<T> request) {
        TaobaoParser<T> parser = null;
        if (this.needEnableParser) {
            String realFormat = request.getTopApiFormat() != null ? request.getTopApiFormat() : this.format;
            String realResponseType = this.getRealResponseType(request.getTopApiFormat() != null ? request.getTopApiFormat() : this.format, request.getTopResponseType());
            parser = "xml".equals(realFormat) || "xml2".equals(realFormat) ? new ObjectXmlParser<T>(request.getResponseClass()) : (realResponseType != null && (realResponseType.equals("qimen1") || realResponseType.equals("qimen2")) ? new ObjectJsonParser<T>(request.getResponseClass(), true) : new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson));
        }
        return parser;
    }

    private <T extends TaobaoResponse> T parseBody(TaobaoParser<T> parser, TaobaoRequest<T> request, RequestParametersHolder requestHolder) throws ApiException {
        String body = requestHolder.getResponseBody();
        TaobaoResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (TaobaoResponse)parser.parse(body, this.getRealResponseType(request.getTopApiFormat() != null ? request.getTopApiFormat() : this.format, request.getTopResponseType()));
            if (tRsp == null) {
                try {
                    tRsp = (TaobaoResponse)request.getResponseClass().newInstance();
                }
                catch (Exception e) {
                    throw new ApiException(e);
                }
            }
            tRsp.setBody(body);
            tRsp.setRequestUrl(requestHolder.getRequestUrl());
            tRsp.setHeaderContent(requestHolder.getResponseHeaders());
        } else {
            try {
                tRsp = (TaobaoResponse)request.getResponseClass().newInstance();
                tRsp.setBody(body);
                tRsp.setRequestUrl(requestHolder.getRequestUrl());
                tRsp.setHeaderContent(requestHolder.getResponseHeaders());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        return (T)tRsp;
    }

    private <T extends TaobaoResponse> RequestParametersHolder invokeApi(TaobaoRequest<T> request, String session, long start) throws ApiException {
        RequestDTO requestDTO = new RequestDTO();
        requestDTO.setRequestBase(request);
        requestDTO.setTargetAppKey(request.getTargetAppKey());
        requestDTO.setTimestamp(request.getTimestamp());
        requestDTO.setHeaderMap(request.getHeaderMap());
        requestDTO.setTextParams(request.getTextParams());
        requestDTO.setContentType(request.getTopContentType());
        requestDTO.setApiMethodName(request.getApiMethodName());
        requestDTO.setApiVersion(request.getTopApiVersion());
        requestDTO.setFormat(request.getTopApiFormat());
        requestDTO.setApiCallType(request.getTopApiCallType());
        if (StringUtils.isEmpty(requestDTO.getBody())) {
            requestDTO.setBody(RequestBodyConverter.getRequestBody(request, request.getTopContentType()));
        }
        return this.invokeApi(requestDTO, session, start);
    }

    protected RequestParametersHolder invokeApi(RequestDTO request, String session, long start) throws ApiException {
        Long timestamp;
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        if (request.getTextParams() == null) {
            request.setTextParams(new HashMap<String, String>());
        }
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("v", request.getApiVersion() != null ? request.getApiVersion() : this.version);
        if (this.appKey != null) {
            protocalMustParams.put("app_key", this.appKey);
        }
        if ((timestamp = request.getTimestamp()) == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", request.getFormat() != null ? request.getFormat() : this.format);
        protocalOptParams.put("sign_method", this.signMethod);
        protocalOptParams.put("session", session);
        protocalOptParams.put("partner_id", this.getSdkVersion());
        protocalOptParams.put("target_app_key", request.getTargetAppKey());
        if (this.useSimplifyJson) {
            protocalOptParams.put("simplify", Boolean.TRUE.toString());
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        Boolean isXml = "xml".equals(request.getContentType());
        Boolean isJson = "json".equals(request.getContentType());
        String apiBody = request.getBody();
        if (isXml.booleanValue() && StringUtils.isEmpty(apiBody)) {
            XmlWriter writer = new XmlWriter(true, "request", QimenRequest.class);
            apiBody = writer.write(request);
        }
        String realServerUrl = this.serverUrl;
        try {
            String traceRequestUrl;
            String fullUrl;
            if (request.getApiCallType() == null) {
                if (isJson.booleanValue() || isXml.booleanValue()) {
                    protocalMustParams.put("sign", TaobaoUtils.signTopRequestWithBody(requestHolder, apiBody, this.appSecret, this.signMethod));
                } else {
                    protocalMustParams.put("sign", TaobaoUtils.signTopRequest(requestHolder, this.appSecret, this.signMethod));
                }
            }
            realServerUrl = this.getServerUrl(this.serverUrl, request.getApiMethodName(), session, appParams);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String appParamsQuery = WebUtils.buildQuery(appParams, "UTF-8");
            if (isJson.booleanValue() || isXml.booleanValue()) {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
            } else {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            }
            requestHolder.setRequestUrl(traceRequestUrl);
            HttpResponseData data = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (this.getTopHttpDnsHost() != null) {
                request.getHeaderMap().put("TOP_HTTP_DNS_HOST", this.getTopHttpDnsHost());
            }
            if (request.getRequestBase() != null && request.getRequestBase() instanceof TaobaoUploadRequest) {
                TaobaoUploadRequest uRequest = (TaobaoUploadRequest)request.getRequestBase();
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                data = WebV2Utils.doPost(fullUrl, (Map<String, String>)appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            } else {
                byte[] bodyByte;
                byte[] byArray = bodyByte = apiBody == null ? new byte[]{} : apiBody.getBytes("UTF-8");
                data = isJson != false ? WebV2Utils.doPost(fullUrl, "application/json;charset=utf-8", bodyByte, this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy()) : (isXml != false ? WebV2Utils.doPost(fullUrl, "text/xml;charset=utf-8", bodyByte, this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy()) : WebV2Utils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy()));
            }
            requestHolder.setResponseBody(data.getBody());
            requestHolder.setResponseHeaders(data.getHeaders());
        }
        catch (IOException e) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), realServerUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        return requestHolder;
    }

    protected void setRealFormat(String responseType) {
        if (responseType == null) {
            return;
        }
        if ("qimen2".equals(responseType)) {
            // empty if block
        }
    }

    protected String getRealResponseType(String format, String responseType) {
        return "json2".equals(this.format) || "xml2".equals(this.format) ? "qimen2" : responseType;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getFormat() {
        return this.format;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isNeedCheckRequest() {
        return this.needCheckRequest;
    }

    public boolean isUseSimplifyJson() {
        return this.useSimplifyJson;
    }

    public boolean isUseGzipEncoding() {
        return this.useGzipEncoding;
    }

    public boolean isNeedEnableParser() {
        return this.needEnableParser;
    }

    public boolean isEnableApiReporter() {
        return this.enableApiReporter;
    }

    public void setEnableApiReporter(boolean enableApiReporter) {
        this.enableApiReporter = enableApiReporter;
    }
}

