/*
 * Decompiled with CFR 0.152.
 */
package com.xiaohongshu.fls.opensdk.client;

import com.alibaba.fastjson.JSON;
import com.xiaohongshu.fls.opensdk.client.BaseClient;
import com.xiaohongshu.fls.opensdk.entity.BaseResponse;
import com.xiaohongshu.fls.opensdk.entity.data.request.BatchDecryptRequest;
import com.xiaohongshu.fls.opensdk.entity.data.request.BatchDesensitiseRequest;
import com.xiaohongshu.fls.opensdk.entity.data.request.BatchIndexRequest;
import com.xiaohongshu.fls.opensdk.entity.data.response.BatchDecryptResponse;
import com.xiaohongshu.fls.opensdk.entity.data.response.BatchDesensitiseResponse;
import com.xiaohongshu.fls.opensdk.entity.data.response.BatchIndexResponse;
import com.xiaohongshu.fls.opensdk.util.Utils;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;

public class DataClient
extends BaseClient {
    public DataClient(String url, String appId, String version, String appSecret) {
        super(url, appId, version, appSecret);
    }

    public BaseResponse<BatchDecryptResponse> execute(BatchDecryptRequest request, String accessToken) throws IOException {
        BaseResponse<BatchDecryptResponse> response = new BaseResponse<BatchDecryptResponse>();
        request.setMethod("data.batchDecrypt");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            BatchDecryptResponse batchDecryptResponse = (BatchDecryptResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), BatchDecryptResponse.class);
            response.setSuccessResponse(batchDecryptResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<BatchDesensitiseResponse> execute(BatchDesensitiseRequest request, String accessToken) throws IOException {
        BaseResponse<BatchDesensitiseResponse> response = new BaseResponse<BatchDesensitiseResponse>();
        request.setMethod("data.batchDesensitise");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            BatchDesensitiseResponse batchDesensitiseResponse = (BatchDesensitiseResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), BatchDesensitiseResponse.class);
            response.setSuccessResponse(batchDesensitiseResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<BatchIndexResponse> execute(BatchIndexRequest request, String accessToken) throws IOException {
        BaseResponse<BatchIndexResponse> response = new BaseResponse<BatchIndexResponse>();
        request.setMethod("data.batchIndex");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            BatchIndexResponse batchIndexResponse = (BatchIndexResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), BatchIndexResponse.class);
            response.setSuccessResponse(batchIndexResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }
}

