/*
 * Decompiled with CFR 0.152.
 */
package com.xiaohongshu.fls.opensdk.client;

import com.alibaba.fastjson.JSON;
import com.xiaohongshu.fls.opensdk.client.BaseClient;
import com.xiaohongshu.fls.opensdk.entity.BaseResponse;
import com.xiaohongshu.fls.opensdk.entity.inventory.request.GetItemStockRequest;
import com.xiaohongshu.fls.opensdk.entity.inventory.request.GetSkuStockRequest;
import com.xiaohongshu.fls.opensdk.entity.inventory.request.IncItemStockRequest;
import com.xiaohongshu.fls.opensdk.entity.inventory.request.IncSkuStockRequest;
import com.xiaohongshu.fls.opensdk.entity.inventory.request.SyncItemStockRequest;
import com.xiaohongshu.fls.opensdk.entity.inventory.request.SyncSkuStockRequest;
import com.xiaohongshu.fls.opensdk.entity.inventory.response.ItemStockResponse;
import com.xiaohongshu.fls.opensdk.entity.inventory.response.SkuStockResponse;
import com.xiaohongshu.fls.opensdk.util.Utils;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;

public class InventoryClient
extends BaseClient {
    public InventoryClient(String url, String appId, String version, String appSecret) {
        super(url, appId, version, appSecret);
    }

    public BaseResponse<ItemStockResponse> execute(GetItemStockRequest request, String accessToken) throws IOException {
        BaseResponse<ItemStockResponse> response = new BaseResponse<ItemStockResponse>();
        request.setMethod("inventory.getItemStock");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            ItemStockResponse itemStockResponse = (ItemStockResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), ItemStockResponse.class);
            response.setSuccessResponse(itemStockResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<ItemStockResponse> execute(SyncItemStockRequest request, String accessToken) throws IOException {
        BaseResponse<ItemStockResponse> response = new BaseResponse<ItemStockResponse>();
        request.setMethod("inventory.syncItemStock");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            ItemStockResponse itemStockResponse = (ItemStockResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), ItemStockResponse.class);
            response.setSuccessResponse(itemStockResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<ItemStockResponse> execute(IncItemStockRequest request, String accessToken) throws IOException {
        BaseResponse<ItemStockResponse> response = new BaseResponse<ItemStockResponse>();
        request.setMethod("inventory.incItemStock");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            ItemStockResponse itemStockResponse = (ItemStockResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), ItemStockResponse.class);
            response.setSuccessResponse(itemStockResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<SkuStockResponse> execute(GetSkuStockRequest request, String accessToken) throws IOException {
        BaseResponse<SkuStockResponse> response = new BaseResponse<SkuStockResponse>();
        request.setMethod("inventory.getSkuStock");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            SkuStockResponse skuStockResponse = (SkuStockResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), SkuStockResponse.class);
            response.setSuccessResponse(skuStockResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<SkuStockResponse> execute(SyncSkuStockRequest request, String accessToken) throws IOException {
        BaseResponse<SkuStockResponse> response = new BaseResponse<SkuStockResponse>();
        request.setMethod("inventory.syncSkuStock");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            SkuStockResponse skuStockResponse = (SkuStockResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), SkuStockResponse.class);
            response.setSuccessResponse(skuStockResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }

    public BaseResponse<SkuStockResponse> execute(IncSkuStockRequest request, String accessToken) throws IOException {
        BaseResponse<SkuStockResponse> response = new BaseResponse<SkuStockResponse>();
        request.setMethod("inventory.incSkuStock");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString((Object)request);
        RequestBody body = RequestBody.create((MediaType)JSONTYPE, (String)bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean((Map)bodyMap, (Object)"success").booleanValue()) {
            SkuStockResponse skuStockResponse = (SkuStockResponse)JSON.parseObject((String)JSON.toJSONString(bodyMap.get("data")), SkuStockResponse.class);
            response.setSuccessResponse(skuStockResponse);
        } else {
            response.setFailResponse(bodyMap.get("error_msg").toString(), bodyMap.get("error_code").toString());
        }
        return response;
    }
}

