/*
 * Decompiled with CFR 0.152.
 */
package com.util.seed;

import com.util.seed.CryptoPadding;

public class AnsiX923Padding
implements CryptoPadding {
    private String name = "ANSI-X.923-Padding";
    private final byte PADDING_VALUE = 0;

    public byte[] addPadding(byte[] source, int blockSize) {
        int paddingCnt = source.length % blockSize;
        byte[] paddingResult = null;
        if (paddingCnt != 0) {
            paddingResult = new byte[source.length + (blockSize - paddingCnt)];
            System.arraycopy(source, 0, paddingResult, 0, source.length);
            int addPaddingCnt = blockSize - paddingCnt;
            int i = 0;
            while (i < addPaddingCnt) {
                paddingResult[source.length + i] = 0;
                ++i;
            }
            paddingResult[paddingResult.length - 1] = (byte)addPaddingCnt;
        } else {
            paddingResult = source;
        }
        return paddingResult;
    }

    public byte[] removePadding(byte[] source, int blockSize) {
        byte[] paddingResult = null;
        boolean isPadding = false;
        byte lastValue = source[source.length - 1];
        if (lastValue < blockSize - 1) {
            int zeroPaddingCount = lastValue - 1;
            int i = 2;
            while (i < zeroPaddingCount + 2) {
                if (source[source.length - i] != 0) {
                    isPadding = false;
                    break;
                }
                ++i;
            }
            isPadding = true;
        } else {
            isPadding = false;
        }
        if (isPadding) {
            paddingResult = new byte[source.length - lastValue];
            System.arraycopy(source, 0, paddingResult, 0, paddingResult.length);
        } else {
            paddingResult = source;
        }
        return paddingResult;
    }

    public String getName() {
        return this.name;
    }
}

