/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.db;

import cn.dreampie.common.plugin.db.DbSource;
import cn.dreampie.common.util.FileUtils;
import cn.dreampie.common.util.PropertiesUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jfinal.kit.PathKit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String config = "/application.properties";
    private Properties properties;

    public DbConfig() {
        this.properties = PropertiesUtils.me().loadPropertyFile(this.config);
    }

    public DbConfig(String config) {
        this.config = config;
        this.properties = PropertiesUtils.me().loadPropertyFile(config);
    }

    public List<String> getAllDbNames() {
        HashSet dbNames = Sets.newHashSet();
        Enumeration<Object> enums = this.properties.keys();
        String key = null;
        String dbName = null;
        while (enums.hasMoreElements()) {
            key = enums.nextElement() + "";
            if (!key.startsWith("db.")) continue;
            dbName = key.split("\\.")[1];
            dbNames.add(dbName);
        }
        return new ArrayList<String>(dbNames);
    }

    public Map<String, DbSource> getAllDbSources() {
        HashMap dbSourceMap = Maps.newHashMap();
        List<String> dbNames = this.getAllDbNames();
        for (String dbName : dbNames) {
            dbSourceMap.put(dbName, new DbSource(this.properties.getProperty("db." + dbName + ".driver"), this.properties.getProperty("db." + dbName + ".url"), this.properties.getProperty("db." + dbName + ".user"), this.properties.getProperty("db." + dbName + ".password")));
        }
        return dbSourceMap;
    }

    public boolean initOnMigrate(String dbName) {
        return this.properties.getProperty("db." + dbName + ".migration.initOnMigrate", "false").equals("true");
    }

    public boolean migrateAuto(String dbName) {
        return this.properties.getProperty("db." + dbName + ".migration.auto", "false").equals("true");
    }

    public boolean migrationFileDirectoryExists(String path) {
        if (FileUtils.me().exist(PathKit.getRootClassPath() + path)) {
            this.logger.debug("Directory for migration files found." + path);
            return true;
        }
        this.logger.warn("Directory for migration files not found." + path);
        return false;
    }

    public boolean isClean(String dbName) {
        return PropertiesUtils.me().loadPropertyFile(this.config).getProperty("db." + dbName + ".valid.clean", "false").equals("true");
    }

    public boolean isDev() {
        return PropertiesUtils.me().loadPropertyFile(this.config).getProperty("devMode", "false").equals("true");
    }
}

