/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.db.druid;

import cn.dreampie.common.plugin.db.tx.XAXid;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.xa.DruidXADataSource;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class DruidXAPlugin
implements IPlugin,
IDataSourceProvider {
    private String url;
    private String username;
    private String password;
    private String driverClass = "com.mysql.jdbc.Driver";
    private int initialSize = 10;
    private int minIdle = 10;
    private int maxActive = 100;
    private long maxWait = -1L;
    private long timeBetweenEvictionRunsMillis = 60000L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long timeBetweenConnectErrorMillis = 30000L;
    private String validationQuery = "select 1";
    private boolean testWhileIdle = true;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean removeAbandoned = false;
    private long removeAbandonedTimeoutMillis = 300000L;
    private boolean logAbandoned = false;
    private int maxPoolPreparedStatementPerConnectionSize = -1;
    private String filters;
    private List<Filter> filterList;
    private DruidXADataSource ds;

    public DruidXAPlugin(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public DruidXAPlugin(String url, String username, String password, String driverClass) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
    }

    public DruidXAPlugin(String url, String username, String password, String driverClass, String filters) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
        this.filters = filters;
    }

    public DruidXAPlugin setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public synchronized DruidXAPlugin addFilter(Filter filter) {
        if (this.filterList == null) {
            this.filterList = new ArrayList<Filter>();
        }
        this.filterList.add(filter);
        return this;
    }

    public boolean start() {
        this.ds = new DruidXADataSource();
        this.ds.setUrl(this.url);
        this.ds.setUsername(this.username);
        this.ds.setPassword(this.password);
        this.ds.setDriverClassName(this.driverClass);
        this.ds.setInitialSize(this.initialSize);
        this.ds.setMinIdle(this.minIdle);
        this.ds.setMaxActive(this.maxActive);
        this.ds.setMaxWait(this.maxWait);
        this.ds.setTimeBetweenConnectErrorMillis(this.timeBetweenConnectErrorMillis);
        this.ds.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.ds.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.ds.setValidationQuery(this.validationQuery);
        this.ds.setTestWhileIdle(this.testWhileIdle);
        this.ds.setTestOnBorrow(this.testOnBorrow);
        this.ds.setTestOnReturn(this.testOnReturn);
        this.ds.setRemoveAbandoned(this.removeAbandoned);
        this.ds.setRemoveAbandonedTimeoutMillis(this.removeAbandonedTimeoutMillis);
        this.ds.setLogAbandoned(this.logAbandoned);
        this.ds.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
        if (StrKit.notBlank((String)this.filters)) {
            try {
                this.ds.setFilters(this.filters);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.addFilterList(this.ds);
        return true;
    }

    private void addFilterList(DruidXADataSource ds) {
        if (this.filterList != null) {
            List targetList = ds.getProxyFilters();
            for (Filter add : this.filterList) {
                boolean found = false;
                for (Filter target : targetList) {
                    if (!add.getClass().equals(target.getClass())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                targetList.add(add);
            }
        }
    }

    public boolean stop() {
        if (this.ds != null) {
            this.ds.close();
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public DruidXAPlugin set(int initialSize, int minIdle, int maxActive) {
        this.initialSize = initialSize;
        this.minIdle = minIdle;
        this.maxActive = maxActive;
        return this;
    }

    public DruidXAPlugin setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public DruidXAPlugin setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    public DruidXAPlugin setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public DruidXAPlugin setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public DruidXAPlugin setMaxWait(long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public DruidXAPlugin setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public DruidXAPlugin setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        return this;
    }

    public DruidXAPlugin setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public DruidXAPlugin setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public DruidXAPlugin setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public DruidXAPlugin setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public DruidXAPlugin setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
        return this;
    }

    public final void setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
    }

    public final void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public final void setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
    }

    public final void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    private static DruidXADataSource getDruidXADataSource(String url, String username, String password) {
        DruidXAPlugin plugin = new DruidXAPlugin(url, username, password);
        DruidXADataSource ds = new DruidXADataSource();
        ds.setUrl(plugin.url);
        ds.setUsername(plugin.username);
        ds.setPassword(plugin.password);
        ds.setDriverClassName(plugin.driverClass);
        ds.setInitialSize(plugin.initialSize);
        ds.setMinIdle(plugin.minIdle);
        ds.setMaxActive(plugin.maxActive);
        ds.setMaxWait(plugin.maxWait);
        ds.setTimeBetweenConnectErrorMillis(plugin.timeBetweenConnectErrorMillis);
        ds.setTimeBetweenEvictionRunsMillis(plugin.timeBetweenEvictionRunsMillis);
        ds.setMinEvictableIdleTimeMillis(plugin.minEvictableIdleTimeMillis);
        ds.setValidationQuery(plugin.validationQuery);
        ds.setTestWhileIdle(plugin.testWhileIdle);
        ds.setTestOnBorrow(plugin.testOnBorrow);
        ds.setTestOnReturn(plugin.testOnReturn);
        ds.setRemoveAbandoned(plugin.removeAbandoned);
        ds.setRemoveAbandonedTimeoutMillis(plugin.removeAbandonedTimeoutMillis);
        ds.setLogAbandoned(plugin.logAbandoned);
        ds.setMaxPoolPreparedStatementPerConnectionSize(plugin.maxPoolPreparedStatementPerConnectionSize);
        if (StrKit.notBlank((String)plugin.filters)) {
            try {
                ds.setFilters(plugin.filters);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        plugin.addFilterList(ds);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException {
        DruidXADataSource ds1 = DruidXAPlugin.getDruidXADataSource("jdbc:mysql://192.168.1.211/sm_card?useUnicode=true&characterEncoding=UTF-8", "dev", "dev1010");
        DruidXADataSource ds2 = DruidXAPlugin.getDruidXADataSource("jdbc:mysql://192.168.1.211/sm_shop_master?useUnicode=true&characterEncoding=UTF-8", "dev", "dev1010");
        boolean result = true;
        XAConnection xaConnection1 = ds1.getXAConnection();
        Connection connection1 = xaConnection1.getConnection();
        connection1.setAutoCommit(false);
        connection1.setTransactionIsolation(2);
        XAResource xaResource1 = xaConnection1.getXAResource();
        XAXid xid1 = XAXid.uniqueXid(1);
        XAConnection xaConnection2 = ds2.getXAConnection();
        Connection connection2 = xaConnection2.getConnection();
        connection2.setAutoCommit(false);
        connection2.setTransactionIsolation(2);
        XAResource xaResource2 = xaConnection2.getXAResource();
        XAXid xid2 = XAXid.uniqueXid(1);
        int result1 = -1;
        int result2 = -1;
        try {
            xaResource1.setTransactionTimeout(0);
            xaResource1.start(xid1, 0);
            try {
                Statement stmt1 = connection1.createStatement();
                stmt1.executeUpdate("UPDATE fun_card SET state=0 WHERE id=30000;");
                xaResource1.end(xid1, 0x4000000);
            }
            catch (SQLException e) {
                e.printStackTrace();
                xaResource1.end(xid1, 0x20000000);
                if (result) {
                    // empty if block
                }
                result = false;
            }
            result1 = xaResource1.prepare(xid1);
            xaResource2.setTransactionTimeout(0);
            xaResource2.start(xid2, 0);
            try {
                Statement stmt2 = connection2.createStatement();
                stmt2.executeUpdate("UPDATE com_account_card SET use_count=0  WHERE id=107;");
                xaResource2.end(xid2, 0x4000000);
            }
            catch (SQLException e) {
                e.printStackTrace();
                xaResource2.end(xid2, 0x20000000);
                if (result) {
                    // empty if block
                }
                result = false;
            }
            result2 = xaResource2.prepare(xid2);
            if (result1 == 0 && result2 == 0) {
                result = result;
            }
        }
        catch (XAException e) {
            e.printStackTrace();
            if (result) {
                // empty if block
            }
            result = false;
        }
        finally {
            try {
                if (result) {
                    xaResource1.commit(xid1, false);
                    xaResource2.commit(xid2, false);
                } else {
                    if (result1 == 0) {
                        xaResource1.rollback(xid1);
                    }
                    if (result2 == 0) {
                        xaResource2.rollback(xid2);
                    }
                }
                connection1.close();
                xaConnection1.close();
                connection2.close();
                xaConnection2.close();
            }
            catch (XAException e) {
                e.printStackTrace();
            }
        }
    }
}

