/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.lesscss;

import cn.dreampie.common.plugin.lesscss.compiler.LessCssCompiler;
import cn.dreampie.common.plugin.lesscss.compiler.LessExecuteListener;
import cn.dreampie.common.plugin.lesscss.compiler.LessExecuteThread;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.lesscss.LessCompiler;
import org.lesscss.LessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class LessCssPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int restartInterval = 1000;
    private LessCssCompiler lessCssCompiler;

    public LessCssPlugin() {
        this.setLessCssCompiler("/lesscss/", "/style/", false, true);
    }

    public LessCssPlugin(String in, String out) {
        this.setLessCssCompiler(in, out, false, true);
    }

    public LessCssPlugin(LessCssCompiler lessCssCompiler) {
        this.lessCssCompiler = lessCssCompiler;
    }

    public LessCssPlugin(int restartInterval, LessCssCompiler lessCssCompiler) {
        this.restartInterval = restartInterval;
        this.lessCssCompiler = lessCssCompiler;
    }

    private void setLessCssCompiler(String in, String out, boolean compress, boolean watch) {
        this.lessCssCompiler = new LessCssCompiler();
        this.lessCssCompiler.setBuildContext(ThreadBuildContext.getContext());
        this.lessCssCompiler.setSourceDirectory(new File(PathKit.getWebRootPath() + in));
        this.lessCssCompiler.setOutputDirectory(new File(PathKit.getWebRootPath() + out));
        this.lessCssCompiler.setCompress(compress);
        this.lessCssCompiler.setWatch(watch);
    }

    public boolean start() {
        LessExecuteThread run = new LessExecuteThread(this.lessCssCompiler, this.restartInterval);
        LessExecuteListener listen = new LessExecuteListener(run);
        run.addObserver(listen);
        new Thread(run).start();
        return true;
    }

    public boolean stop() {
        return false;
    }

    public static void main(String[] args) throws LessException, IOException {
        LessCompiler lessCompiler = new LessCompiler(Arrays.asList("--relative-urls", "--strict-math=on"));
        String css = lessCompiler.compile("@color: #4D926F; #header { color: @color; }");
        lessCompiler = new LessCompiler(Arrays.asList("--relative-urls", "--strict-math=on"));
        css = lessCompiler.compile(new File(PathKit.getWebRootPath() + "/src/main/webapp/css/app/_layout.less"));
        System.out.println(css);
        LessCssCompiler lessCssCompiler = new LessCssCompiler();
        lessCssCompiler.setBuildContext(ThreadBuildContext.getContext());
        lessCssCompiler.setSourceDirectory(new File(PathKit.getWebRootPath() + "/css/"));
        lessCssCompiler.setOutputDirectory(new File(PathKit.getRootClassPath() + "/css/"));
        lessCssCompiler.setForce(true);
        lessCssCompiler.setCompress(true);
        lessCssCompiler.setWatch(true);
        lessCssCompiler.execute();
    }
}

