/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.patchca;

import cn.dreampie.common.plugin.patchca.SimpleBackgroundFactory;
import cn.dreampie.common.plugin.patchca.color.ColorFactory;
import cn.dreampie.common.plugin.patchca.filter.ConfigurableFilterFactory;
import cn.dreampie.common.plugin.patchca.filter.library.WobbleImageOp;
import cn.dreampie.common.plugin.patchca.font.RandomFontFactory;
import cn.dreampie.common.plugin.patchca.service.Captcha;
import cn.dreampie.common.plugin.patchca.service.ConfigurableCaptchaService;
import cn.dreampie.common.plugin.patchca.text.renderer.BestFitTextRenderer;
import cn.dreampie.common.plugin.patchca.text.renderer.TextRenderer;
import cn.dreampie.common.plugin.patchca.word.RandomWordFactory;
import cn.dreampie.common.util.security.EncriptionUtils;
import com.jfinal.render.Render;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchcaRender
extends Render {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String CODE_CHAR = "0123456789";
    private static final int MIN_NUM = 4;
    private static final int MAX_NUM = 4;
    private static final int FONT_MIN_SIZE = 20;
    private static final int FONT_MAX_SIZE = 20;
    private static final double X_AMPLITUDE = 1.6;
    private static final double Y_AMPLITUDE = 0.8;
    private static final int TOP_MARGIN = 1;
    private static final int BOTTOM_MARGIN = 1;
    private static final int WIDTH = 118;
    private static final int HEIGHT = 41;
    private String captchaName = "captcha";
    private float alpha = 1.0f;
    private ConfigurableCaptchaService configurableCaptchaService = null;
    private ColorFactory colorFactory = null;
    private RandomFontFactory fontFactory = null;
    private RandomWordFactory wordFactory = null;
    private TextRenderer textRenderer = null;

    public PatchcaRender() {
        this(4, 4, 118, 41, 20, 20, null);
    }

    public PatchcaRender(int num) {
        this(num, num, 118, 41, 20, 20, null);
    }

    public PatchcaRender(int minnum, int maxnum, int width, int height, int fontsize) {
        this(minnum, maxnum, width, height, fontsize, fontsize, null);
    }

    public PatchcaRender(int minnum, int maxnum, int width, int height, int fontsize, String code) {
        this(minnum, maxnum, width, height, fontsize, fontsize, code);
    }

    public PatchcaRender(int minnum, int maxnum, int width, int height, int fontmin, int fontmax, String code) {
        if (minnum <= 0) {
            minnum = 4;
        }
        if (maxnum <= 0) {
            maxnum = 4;
        }
        if (width <= 0) {
            width = 118;
        }
        if (height <= 0) {
            height = 41;
        }
        if (fontmin <= 0) {
            fontmin = 20;
        }
        if (fontmax <= 0) {
            fontmax = 20;
        }
        if (code == null || code.isEmpty()) {
            code = CODE_CHAR;
        }
        this.configurableCaptchaService = new ConfigurableCaptchaService();
        this.colorFactory = new ColorFactory(){

            public Color getColor(int index) {
                return new Color(0, 0, 0);
            }
        };
        this.configurableCaptchaService.setColorFactory(this.colorFactory);
        this.fontFactory = new RandomFontFactory();
        this.fontFactory.setMaxSize(fontmin);
        this.fontFactory.setMinSize(fontmax);
        this.configurableCaptchaService.setFontFactory(this.fontFactory);
        this.wordFactory = new RandomWordFactory();
        this.wordFactory.setCharacters(code);
        this.wordFactory.setMaxLength(maxnum);
        this.wordFactory.setMinLength(minnum);
        this.configurableCaptchaService.setWordFactory(this.wordFactory);
        SimpleBackgroundFactory backgroundFactory = new SimpleBackgroundFactory(this.alpha);
        this.configurableCaptchaService.setBackgroundFactory(backgroundFactory);
        ConfigurableFilterFactory filterFactory = new ConfigurableFilterFactory();
        ArrayList<BufferedImageOp> filters = new ArrayList<BufferedImageOp>();
        WobbleImageOp wobbleImageOp = new WobbleImageOp();
        wobbleImageOp.setEdgeMode(2);
        wobbleImageOp.setxAmplitude(1.6);
        wobbleImageOp.setyAmplitude(0.8);
        filters.add(wobbleImageOp);
        filterFactory.setFilters(filters);
        this.configurableCaptchaService.setFilterFactory(filterFactory);
        this.textRenderer = new BestFitTextRenderer();
        this.textRenderer.setBottomMargin(1);
        this.textRenderer.setTopMargin(1);
        this.configurableCaptchaService.setTextRenderer(this.textRenderer);
        this.configurableCaptchaService.setWidth(width);
        this.configurableCaptchaService.setHeight(height);
    }

    public void render() {
        ServletOutputStream outputStream = null;
        Captcha captcha = this.configurableCaptchaService.getCaptcha();
        String captchaCode = captcha.getChallenge();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("captcha:" + captchaCode);
        }
        Session session = SecurityUtils.getSubject().getSession();
        session.setAttribute((Object)this.captchaName, (Object)EncriptionUtils.encrypt(captchaCode));
        session.setAttribute((Object)(this.captchaName + "_time"), (Object)new Date().getTime());
        BufferedImage bufferedImage = captcha.getImage();
        try {
            outputStream = this.response.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getCaptchaName() {
        return this.captchaName;
    }

    public void setCaptchaName(String captchaName) {
        this.captchaName = captchaName;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

