/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.quartz;

import cn.dreampie.common.util.TimeUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzFactory {
    public SchedulerFactory sf;
    private static QuartzFactory quartzFactory = new QuartzFactory();

    private QuartzFactory() {
    }

    public static QuartzFactory me() {
        return quartzFactory;
    }

    public void startJobOnce(String startTime, int id, String name, String group, Class<? extends Job> jobClass) {
        try {
            Scheduler sched = this.sf.getScheduler();
            JobDetail job = JobBuilder.newJob(jobClass).withIdentity("job_" + name + "_" + id, "group_" + group + "_" + id).requestRecovery().build();
            job.getJobDataMap().put(group + "_" + name, id);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger_" + name + "_" + id, "group_" + group + "_" + id).startAt(TimeUtils.me().toDateTime(startTime).toDate()).build();
            sched.scheduleJob(job, trigger);
            sched.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startJobCron(String startTime, int id, String name, String group, String cronExp, Class<? extends Job> jobClass) {
        try {
            Scheduler sched = this.sf.getScheduler();
            JobDetail job = JobBuilder.newJob(jobClass).withIdentity("job_" + name + "_" + id, "group_" + group + "_" + id).requestRecovery().build();
            job.getJobDataMap().put(group + "_" + name, id);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + name + "_" + id, "group_" + group + "_" + id).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExp)).build();
            sched.scheduleJob(job, (Trigger)trigger);
            sched.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopJob(String name, String group, int id) {
        try {
            TriggerKey triggerKey;
            Scheduler scheduler;
            Trigger trigger;
            if (this.sf != null && (trigger = (scheduler = this.sf.getScheduler()).getTrigger(triggerKey = TriggerKey.triggerKey((String)("trigger_" + name + "_" + id), (String)("group_" + group + "_" + id)))) != null) {
                scheduler.pauseTrigger(triggerKey);
                scheduler.unscheduleJob(triggerKey);
                scheduler.deleteJob(trigger.getJobKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

