/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyAccessControlFilter
extends PathMatchingFilter {
    private static final Logger log = LoggerFactory.getLogger(MyAccessControlFilter.class);
    public static final String DEFAULT_LOGIN_URL = "/login";
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    private String failureUrl = "/login";
    private Map<String, String> failureUrlMap;
    private String loginUrl = "/login";
    private Map<String, String> loginUrlMap;

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public Map<String, String> getFailureUrlMap() {
        return this.failureUrlMap;
    }

    public void setFailureUrlMap(Map<String, String> failureUrlMap) {
        this.failureUrlMap = failureUrlMap;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public Map<String, String> getLoginUrlMap() {
        return this.loginUrlMap;
    }

    public void setLoginUrlMap(Map<String, String> loginUrlMap) {
        this.loginUrlMap = loginUrlMap;
    }

    protected Subject getSubject(ServletRequest request, ServletResponse response) {
        return SecurityUtils.getSubject();
    }

    protected abstract boolean isAccessAllowed(ServletRequest var1, ServletResponse var2, Object var3) throws Exception;

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return this.onAccessDenied(request, response);
    }

    protected abstract boolean onAccessDenied(ServletRequest var1, ServletResponse var2) throws Exception;

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return this.isAccessAllowed(request, response, mappedValue) || this.onAccessDenied(request, response, mappedValue);
    }

    protected boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        boolean match = false;
        if (this.loginUrlMap != null) {
            String key;
            Iterator<String> i$ = this.loginUrlMap.keySet().iterator();
            while (i$.hasNext() && !(match = this.pathsMatch(this.loginUrlMap.get(key = i$.next()), request))) {
            }
        } else {
            match = this.pathsMatch(this.getLoginUrl(), request);
        }
        return match;
    }

    protected void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.saveRequest(request);
        this.redirectToLogin(request, response);
    }

    protected void saveRequest(ServletRequest request) {
        WebUtils.saveRequest((ServletRequest)request);
    }

    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        String loginUrl = this.getRealLoginUrl(request);
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)loginUrl);
    }

    public String getRealLoginUrl(ServletRequest request) {
        String loginUrl = "";
        if (this.loginUrlMap != null) {
            Object config = null;
            for (String path : this.appliedPaths.keySet()) {
                if (!this.pathsMatch(path, request)) continue;
                config = this.appliedPaths.get(path);
                break;
            }
            if (config != null) {
                Object[] configArr = config;
                for (String key : this.loginUrlMap.keySet()) {
                    if (!ArrayUtils.contains((Object[])configArr, (Object)key)) continue;
                    loginUrl = this.loginUrlMap.get(key);
                    break;
                }
            }
        }
        if (loginUrl.isEmpty()) {
            loginUrl = this.getLoginUrl();
        }
        return loginUrl;
    }

    public String getRealFailureUrl(ServletRequest request) {
        String failureUrl = "";
        if (this.failureUrlMap != null && this.loginUrlMap != null) {
            String roleKey = null;
            for (String path : this.loginUrlMap.values()) {
                if (!this.pathsMatch(path, request)) continue;
                roleKey = this.loginUrlMap.get(path);
                break;
            }
            if (roleKey != null) {
                failureUrl = this.failureUrlMap.get(roleKey);
            }
        }
        if (failureUrl.isEmpty()) {
            failureUrl = this.getFailureUrl();
        }
        return failureUrl;
    }
}

