/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro;

import cn.dreampie.common.plugin.shiro.CaptchaUsernamePasswordToken;
import cn.dreampie.common.plugin.shiro.MyAuthenticationFilter;
import cn.dreampie.common.plugin.shiro.exception.IncorrectCaptchaException;
import cn.dreampie.common.util.security.EncriptionUtils;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

public abstract class MyAuthenticatingFilter
extends MyAuthenticationFilter {
    public static final String PERMISSIVE = "permissive";
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        CaptchaUsernamePasswordToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        try {
            this.doCaptchaValidate(token);
            Subject subject = this.getSubject(request, response);
            subject.login((AuthenticationToken)token);
            return this.onLoginSuccess((AuthenticationToken)token, subject, request, response);
        }
        catch (AuthenticationException e) {
            return this.onLoginFailure((AuthenticationToken)token, e, request, response);
        }
    }

    protected abstract CaptchaUsernamePasswordToken createToken(ServletRequest var1, ServletResponse var2) throws Exception;

    protected CaptchaUsernamePasswordToken createToken(String username, String password, ServletRequest request, ServletResponse response) {
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        return this.createToken(username, password, rememberMe, host);
    }

    protected CaptchaUsernamePasswordToken createToken(String username, String password, boolean rememberMe, String host) {
        return new CaptchaUsernamePasswordToken(username, password, rememberMe, host);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) throws Exception {
        return false;
    }

    protected String getHost(ServletRequest request) {
        return request.getRemoteHost();
    }

    protected boolean isRememberMe(ServletRequest request) {
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return super.isAccessAllowed(request, response, mappedValue) || !this.isLoginRequest(request, response) && this.isPermissive(mappedValue);
    }

    protected boolean isPermissive(Object mappedValue) {
        if (mappedValue != null) {
            Object[] values = (String[])mappedValue;
            return Arrays.binarySearch(values, PERMISSIVE) >= 0;
        }
        return false;
    }

    protected void cleanup(ServletRequest request, ServletResponse response, Exception existing) throws ServletException, IOException {
        if (existing instanceof UnauthenticatedException || existing instanceof ServletException && existing.getCause() instanceof UnauthenticatedException) {
            try {
                this.onAccessDenied(request, response);
                existing = null;
            }
            catch (Exception e) {
                existing = e;
            }
        }
        super.cleanup(request, response, existing);
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)DEFAULT_CAPTCHA_PARAM);
    }

    protected CaptchaUsernamePasswordToken createToken(String username, String password, String captcha, ServletRequest request, ServletResponse response) {
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        return new CaptchaUsernamePasswordToken(username, password, rememberMe, host, captcha);
    }

    protected void doCaptchaValidate(CaptchaUsernamePasswordToken token) {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new UnknownSessionException("Unable found required Session");
        }
        if (session.getAttribute((Object)DEFAULT_CAPTCHA_PARAM) != null) {
            String captcha = session.getAttribute((Object)DEFAULT_CAPTCHA_PARAM).toString();
            if (token.getCaptcha() != null && captcha.equalsIgnoreCase(EncriptionUtils.encrypt(token.getCaptcha()))) {
                return;
            }
        }
        throw new IncorrectCaptchaException();
    }
}

