/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util;

import cn.dreampie.common.util.ValidateUtils;
import java.io.File;

public class FileUtils {
    private static FileUtils fileUtils = new FileUtils();

    private FileUtils() {
    }

    public static FileUtils me() {
        return fileUtils;
    }

    public boolean delete(File file) {
        boolean result = true;
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    result = result && this.delete(f);
                }
            }
            result = result && file.delete();
            file = null;
        }
        return result;
    }

    public boolean delete(File file, String filename) {
        boolean result = true;
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                if (file.getName().equals(filename)) {
                    for (File f : file.listFiles()) {
                        result = result && this.delete(f);
                    }
                    result = result && file.delete();
                } else {
                    for (File f : file.listFiles()) {
                        result = result && this.delete(f, filename);
                    }
                }
            } else if (file.getName().equals(filename)) {
                result = result && file.delete();
                file = null;
            }
        }
        return result;
    }

    public boolean delete(String path) {
        if (!ValidateUtils.me().isNullOrEmpty(path)) {
            File file = new File(path);
            return this.delete(file);
        }
        return false;
    }

    public boolean delete(String path, String filename) {
        if (!ValidateUtils.me().isNullOrEmpty(path)) {
            File file = new File(path);
            return this.delete(file, filename);
        }
        return false;
    }

    public boolean exist(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            return file.exists();
        }
        return false;
    }

    public boolean existChild(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (!f.isDirectory() && !f.exists()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean exist(String path) {
        if (!ValidateUtils.me().isNullOrEmpty(path)) {
            File file = new File(path);
            if (file.isDirectory()) {
                return true;
            }
            return this.exist(file);
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.me().delete("D:\\workspace\\idea\\dreampie", ".git"));
    }
}

