/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util;

import cn.dreampie.common.util.ValidateUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeUtils {
    private static TimeUtils timeUtils = new TimeUtils();

    private TimeUtils() {
    }

    public static TimeUtils me() {
        return timeUtils;
    }

    public DateTime toDateTime(String dateStr) {
        DateTimeFormatter df = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        DateTime date = df.parseDateTime(dateStr);
        return date;
    }

    public DateTime toDateTime(String dateStr, String format) {
        if (ValidateUtils.me().isNullOrEmpty(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        DateTimeFormatter df = DateTimeFormat.forPattern((String)format);
        DateTime date = df.parseDateTime(dateStr);
        return date;
    }

    public String toString(DateTime date) {
        DateTimeFormatter df = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        String dateStr = date.toString(df);
        return dateStr;
    }

    public String toString(DateTime date, String format) {
        if (ValidateUtils.me().isNullOrEmpty(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        DateTimeFormatter df = DateTimeFormat.forPattern((String)format);
        String dateStr = date.toString(df);
        return dateStr;
    }
}

