/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.web.render;

import cn.dreampie.common.util.ValidateUtils;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;

public class JsonErrorRender
extends Render {
    private static final long serialVersionUID = -7175292712918557096L;
    private static final String contentType = "application/json;charset=" + JsonErrorRender.getEncoding();
    private static final String contentTypeForIE = "text/html;charset=" + JsonErrorRender.getEncoding();
    protected static final String json404 = "404 Not Found";
    protected static final String json500 = "500 Internal Server Error";
    protected static final String json401 = "401 Unauthorized";
    protected static final String json403 = "403 Forbidden";
    protected int errorCode;
    private boolean forIE = false;

    public JsonErrorRender(int errorCode, String view) {
        this.errorCode = errorCode;
        this.view = view;
    }

    public void render() {
        String header = this.request.getHeader("USER-AGENT").toLowerCase();
        this.forIE = header.indexOf("msie") > 0;
        this.response.setStatus(this.getErrorCode());
        String errorJson = null;
        Object error = this.request.getAttribute("errorJson");
        errorJson = ValidateUtils.me().isNullOrEmpty(error) ? this.getErrorJson() : error.toString();
        PrintWriter writer = null;
        try {
            this.response.setContentType(this.forIE ? contentTypeForIE : contentType);
            writer = this.response.getWriter();
            writer.write(errorJson);
            writer.flush();
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public String getErrorJson() {
        int errorCode = this.getErrorCode();
        if (errorCode == 404) {
            return json404;
        }
        if (errorCode == 500) {
            return json500;
        }
        if (errorCode == 401) {
            return json401;
        }
        if (errorCode == 403) {
            return json403;
        }
        return errorCode + " Error";
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

