/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.web.thread;

import cn.dreampie.common.config.ReTurnType;
import com.jfinal.core.Controller;
import com.jfinal.log.Logger;
import com.jfinal.render.JsonRender;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ThreadLocalUtil {
    protected static final Logger logger = Logger.getLogger(ThreadLocalUtil.class);
    private static ThreadLocal<HttpServletRequest> requestLocal = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> responseLocal = new ThreadLocal();

    public static void init(HttpServletRequest request, HttpServletResponse response) {
        ThreadLocalUtil.setRequest(request);
        ThreadLocalUtil.setResponse(response);
    }

    public static HttpServletRequest getRequest() {
        return requestLocal.get();
    }

    public static void setRequest(HttpServletRequest request) {
        requestLocal.set(request);
    }

    public static HttpServletResponse getResponse() {
        return responseLocal.get();
    }

    public static void setResponse(HttpServletResponse response) {
        responseLocal.set(response);
    }

    public static HttpSession getSession() {
        if (requestLocal.get() != null) {
            return requestLocal.get().getSession();
        }
        return null;
    }

    public static ServletContext getServletContex() {
        if (requestLocal.get() != null) {
            return requestLocal.get().getServletContext();
        }
        return null;
    }

    public static ReTurnType returnType() {
        String header;
        HttpServletRequest request = ThreadLocalUtil.getRequest();
        if (request != null && ("XMLHttpRequest".equalsIgnoreCase(header = request.getHeader("X-Requested-With")) || "json".equalsIgnoreCase(request.getParameter("returnType")))) {
            return ReTurnType.JSON;
        }
        return ReTurnType.PAGE;
    }

    public static boolean isAjax() {
        HttpServletRequest request = ThreadLocalUtil.getRequest();
        return request != null && "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    public static boolean isJson() {
        return ThreadLocalUtil.returnType() == ReTurnType.JSON;
    }

    public static boolean isJson(Controller controller) {
        return controller.getRender() instanceof JsonRender;
    }
}

