/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.backups;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.ConcurrentDiskUtil;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.DiskCache;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FailoverReactor {
    private Map<String, Domain> domainMap = new ConcurrentHashMap<String, Domain>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("VIPSERVER-FAILOVER");
            return thread;
        }
    });
    private Timer timer = new Timer(true);
    private Map<String, String> switchParams = new ConcurrentHashMap<String, String>();
    private final long DAY_PERIOD_MILLS = 86400000L;
    private String failoverDir;

    public FailoverReactor() {
        this.init();
    }

    public void init() {
        this.failoverDir = System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.failover", "");
        if (StringUtils.isEmpty(this.failoverDir)) {
            this.failoverDir = "/home/admin/vipsrv-failover/";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 3);
        calendar.set(12, 5);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        if (date.before(new Date())) {
            date = this.addDay(date, 1);
        }
        this.executorService.scheduleWithFixedDelay(new SwitchRefresher(), 0L, 5000L, TimeUnit.MILLISECONDS);
        this.timer.schedule((TimerTask)new DiskFileWriter(), date, 86400000L);
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    File cacheDir = new File(FailoverReactor.this.failoverDir);
                    if (!(cacheDir.exists() && cacheDir.isDirectory() || cacheDir.mkdirs())) {
                        throw new IllegalStateException("failed to create cache dir: " + FailoverReactor.this.failoverDir);
                    }
                    File[] files = cacheDir.listFiles();
                    if (files == null || files.length <= 0) {
                        new DiskFileWriter().run();
                    }
                }
                catch (Throwable e) {
                    VIPClient.LOG.error("NA", "failed to backup file on startup.", e);
                }
            }
        }, 10000L, TimeUnit.MILLISECONDS);
    }

    public Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    public boolean isFailoverSwitch() {
        return Boolean.parseBoolean(this.switchParams.get("failover-mode"));
    }

    public Domain getDom(String key) {
        Domain domain = this.domainMap.get(key);
        if (domain == null) {
            domain = new Domain();
            domain.setName(key);
        }
        return domain;
    }

    class DiskFileWriter
    extends TimerTask {
        DiskFileWriter() {
        }

        @Override
        public void run() {
            Map<String, Domain> map = HostReactor.getDomMap();
            for (Map.Entry<String, Domain> entry : map.entrySet()) {
                Domain domain = entry.getValue();
                if (StringUtils.equals(domain.getKey(), "000--00-ALL_IPS--00--000") || StringUtils.equals(domain.getName(), "envList") || StringUtils.equals(domain.getName(), "00-00---000-ENV_CONFIGS-000---00-00") || StringUtils.equals(domain.getName(), "vipclient.properties") || StringUtils.equals(domain.getName(), "00-00---000-ALL_HOSTS-000---00-00")) continue;
                DiskCache.write(domain, FailoverReactor.this.failoverDir);
            }
        }
    }

    class FailoverFileReader
    implements Runnable {
        FailoverFileReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<String, Domain> domMap = new HashMap<String, Domain>();
            BufferedReader reader = null;
            try {
                File cacheDir = new File(FailoverReactor.this.failoverDir);
                if (!(cacheDir.exists() && cacheDir.isDirectory() || cacheDir.mkdirs())) {
                    throw new IllegalStateException("failed to create cache dir: " + FailoverReactor.this.failoverDir);
                }
                File[] files = cacheDir.listFiles();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals("00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00")) continue;
                    Domain dom = new Domain(file.getName());
                    try {
                        String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                        reader = new BufferedReader(new StringReader(dataString));
                        String json = reader.readLine();
                        if (json != null) {
                            try {
                                dom = JSON.parseObject(json, Domain.class);
                            }
                            catch (Exception e) {
                                VIPClient.LOG.error("NA", "error while parsing cached dom : " + json, e);
                            }
                        }
                    }
                    catch (Exception e) {
                        VIPClient.LOG.error("NA", "failed to read cache for dom: " + file.getName(), e);
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (CollectionUtils.isEmpty(dom.getHosts())) continue;
                    domMap.put(dom.getKey(), dom);
                }
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "failed to read cache file", e);
            }
            if (domMap.size() > 0) {
                FailoverReactor.this.domainMap = domMap;
            }
        }
    }

    class SwitchRefresher
    implements Runnable {
        long lastModifiedMillis = 0L;

        SwitchRefresher() {
        }

        @Override
        public void run() {
            try {
                File switchFile = new File(FailoverReactor.this.failoverDir + "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00");
                if (!switchFile.exists()) {
                    FailoverReactor.this.switchParams.put("failover-mode", "false");
                    VIPClient.LOG.debug("failover switch is not found, " + switchFile.getName());
                    return;
                }
                long modified = switchFile.lastModified();
                if (this.lastModifiedMillis < modified) {
                    this.lastModifiedMillis = modified;
                    String failover = ConcurrentDiskUtil.getFileContent(FailoverReactor.this.failoverDir + "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00", Charset.defaultCharset().toString());
                    if (!StringUtils.isEmpty(failover)) {
                        List<String> lines = Arrays.asList(failover.split(DiskCache.getLineSeperator()));
                        for (String line : lines) {
                            String line1 = line.trim();
                            if (line1.equals("1")) {
                                FailoverReactor.this.switchParams.put("failover-mode", "true");
                                VIPClient.LOG.info("failover-mode is on");
                                new FailoverFileReader().run();
                                continue;
                            }
                            if (!line1.equals("0")) continue;
                            FailoverReactor.this.switchParams.put("failover-mode", "false");
                            VIPClient.LOG.info("failover-mode is off");
                        }
                    } else {
                        FailoverReactor.this.switchParams.put("failover-mode", "false");
                    }
                }
            }
            catch (Throwable e) {
                VIPClient.LOG.error("NA", "failed to read failover switch.", e);
            }
        }
    }
}

