/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.cache;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.ConcurrentDiskUtil;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DiskCache {
    public static void write(Domain dom) {
        DiskCache.write(dom, VIPClient.getCacheDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Domain dom, String dir) {
        BufferedWriter writer = null;
        try {
            DiskCache.makeSureCacheDirExists(dir);
            File file = new File(dir, dom.getKey());
            if (!(file.exists() || file.createNewFile() || file.exists())) {
                throw new IllegalStateException("failed to create cache file");
            }
            StringBuffer keyContentBuffer = new StringBuffer("");
            String json = dom.getJsonFromServer();
            if (StringUtils.isEmpty(json)) {
                json = JSON.toJSONString(dom);
            }
            keyContentBuffer.append(json);
            ConcurrentDiskUtil.writeFileContent(file, keyContentBuffer.toString(), Charset.defaultCharset().toString());
        }
        catch (Throwable e) {
            VIPClient.LOG.error("NA", "failed to write cache for dom:" + dom.getName(), e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable file) {}
        }
    }

    public static String getLineSeperator() {
        String lineSeparator = System.getProperty("line.separator");
        return lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Domain> read() {
        HashMap<String, Domain> domMap = new HashMap<String, Domain>();
        BufferedReader reader = null;
        try {
            File[] files = DiskCache.makeSureCacheDirExists().listFiles();
            if (files == null) {
                return domMap;
            }
            for (File file : files) {
                if (!file.isFile() || file.getName().endsWith("@@meta") || file.getName().endsWith("@@special-url")) continue;
                Domain dom = new Domain(file.getName());
                ArrayList<Host> ips = new ArrayList<Host>();
                dom.setHosts(ips);
                Domain newFormat = null;
                try {
                    String json;
                    String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                    reader = new BufferedReader(new StringReader(dataString));
                    while ((json = reader.readLine()) != null) {
                        try {
                            if (!json.startsWith("{") || !StringUtils.isEmpty((newFormat = JSON.parseObject(json, Domain.class)).getName())) continue;
                            ips.add(JSON.parseObject(json, Host.class));
                        }
                        catch (Throwable e) {
                            VIPClient.LOG.error("NA", "error while parsing cache file: " + json, e);
                        }
                    }
                }
                catch (Exception e) {
                    VIPClient.LOG.error("NA", "failed to read cache for dom: " + file.getName(), e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                if (newFormat != null && !StringUtils.isEmpty(newFormat.getName()) && !CollectionUtils.isEmpty(newFormat.getHosts())) {
                    domMap.put(dom.getKey(), newFormat);
                    continue;
                }
                if (CollectionUtils.isEmpty(dom.getHosts())) continue;
                domMap.put(dom.getKey(), dom);
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to read cache file", e);
        }
        DiskCache.readMetaAndHostsFromSpecialURL(domMap);
        return domMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readMetaAndHostsFromSpecialURL(Map<String, Domain> domMap) {
        BufferedReader reader = null;
        try {
            File[] files = DiskCache.makeSureCacheDirExists().listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                if (file.getName().endsWith("@@meta")) {
                    try {
                        String json;
                        String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                        reader = new BufferedReader(new StringReader(dataString));
                        while ((json = reader.readLine()) != null) {
                            try {
                                Domain domain = JSON.parseObject(json, Domain.class);
                                if (domain == null) continue;
                                for (Domain domain1 : domMap.values()) {
                                    if (!StringUtils.equals(domain1.getName(), domain.getName())) continue;
                                    domain1.setIsUseSpecifiedURL(domain.getIsUseSpecifiedURL());
                                }
                            }
                            catch (Exception e) {
                                VIPClient.LOG.error("NA", "error while parsing cached ip(old format?): " + json);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        VIPClient.LOG.error("NA", "failed to read cache for dom: " + file.getName(), e);
                        continue;
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (Exception e) {}
                    }
                }
                if (!file.getName().endsWith("@@special-url")) continue;
                String key = file.getName().split("@@special-url")[0];
                Domain dom = domMap.get(key);
                if (dom == null) {
                    dom = new Domain(key);
                    domMap.put(key, dom);
                }
                ArrayList<Host> ips = new ArrayList<Host>();
                dom.setHostsFromSpecifiedURL(ips);
                try {
                    String json;
                    String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                    reader = new BufferedReader(new StringReader(dataString));
                    while ((json = reader.readLine()) != null) {
                        try {
                            ips.add(JSON.parseObject(json, Host.class));
                        }
                        catch (Exception e) {
                            VIPClient.LOG.error("NA", "error while parsing cached ip(old format?): " + json);
                        }
                    }
                }
                catch (Exception e) {
                    VIPClient.LOG.error("NA", "failed to read cache for dom: " + file.getName(), e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to read cache file", e);
        }
    }

    private static File makeSureCacheDirExists() {
        return DiskCache.makeSureCacheDirExists(VIPClient.getCacheDir());
    }

    private static File makeSureCacheDirExists(String dir) {
        File cacheDir = new File(dir);
        if (!(cacheDir.exists() && cacheDir.isDirectory() || cacheDir.mkdirs())) {
            throw new IllegalStateException("failed to create cache dir: " + VIPClient.getCacheDir());
        }
        return cacheDir;
    }
}

