/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.net;

import com.alibaba.ans.shaded.com.alibaba.middleware.tls.JavaSSLSocketFactory;
import com.alibaba.ans.shaded.com.alibaba.middleware.tls.util.TlsUtil;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.VIPServerProxy;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.IOUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpClient {
    public static final int TIME_OUT_MILLIS = Integer.parseInt(System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.socket.timeout", "3000"));
    public static final int CON_TIME_OUT_MILLIS = Integer.parseInt(System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.connect.timeout", "1000"));
    private static final boolean enableHttps = Boolean.parseBoolean(System.getProperty("tls.enable", "false"));

    public static String getPrefix() {
        if (enableHttps) {
            return "https://";
        }
        return "http://";
    }

    public static String getServerPort() {
        if (enableHttps) {
            return VIPServerProxy.TLS_SERVER_PORT;
        }
        return VIPServerProxy.SERVER_PORT;
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding) {
        return HttpClient.httpGet(url, headers, paramValues, encoding, TIME_OUT_MILLIS, CON_TIME_OUT_MILLIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding, int timeout, int connTimeout) {
        HttpURLConnection conn = null;
        try {
            String encodedContent = HttpClient.encodingParams(paramValues, encoding);
            url = url + (null == encodedContent ? "" : "?" + encodedContent);
            if (enableHttps && url.startsWith("https")) {
                TlsUtil.replaceHostnameVerifier();
                SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
                HttpsURLConnection httpsConn = (HttpsURLConnection)new URL(url).openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            conn.setConnectTimeout(connTimeout);
            conn.setReadTimeout(timeout);
            conn.setRequestMethod("GET");
            HttpClient.setHeaders(conn, headers, encoding);
            conn.connect();
            VIPClient.LOG.debug("Request from server: " + url);
            HttpResult result = HttpClient.getResult(conn);
            if (result.code != 200) {
                VIPClient.LOG.warn("failed to request " + url + ", caused by " + result.content);
            }
            HttpResult httpResult = result;
            return httpResult;
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    VIPClient.LOG.warn("failed to request " + conn.getURL() + " from " + InetAddress.getByName(conn.getURL().getHost()).getHostAddress());
                }
            }
            catch (Exception e1) {
                VIPClient.LOG.error("NA", "failed to request ", e1);
            }
            VIPClient.LOG.error("NA", "failed to request ", e);
            HttpResult httpResult = new HttpResult(500, e.toString(), Collections.<String, String>emptyMap());
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static HttpResult getResult(HttpURLConnection conn) throws IOException {
        int respCode = conn.getResponseCode();
        InputStream inputStream = 200 == respCode || 304 == respCode ? conn.getInputStream() : conn.getErrorStream();
        HashMap<String, String> respHeaders = new HashMap<String, String>(conn.getHeaderFields().size());
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            respHeaders.put(entry.getKey(), entry.getValue().get(0));
        }
        if ("gzip".equals(respHeaders.get("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return new HttpResult(respCode, IOUtils.toString(inputStream, HttpClient.getCharset(conn)), respHeaders);
    }

    private static String getCharset(HttpURLConnection conn) {
        String contentType = conn.getContentType();
        if (StringUtils.isEmpty(contentType)) {
            return "GBK";
        }
        String[] values = contentType.split(";");
        if (values.length == 0) {
            return "GBK";
        }
        String charset = "GBK";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        conn.addRequestProperty("Accept-Charset", encoding);
    }

    private static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == params || params.isEmpty()) {
            return null;
        }
        params.put("encoding", encoding);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) continue;
            sb.append(entry.getKey()).append("=");
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append("&");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "Wms+rkGG8jlaBBbpl8FIDxxNQGA=");
        System.out.println(HttpClient.encodingParams(params, "utf-8"));
    }

    static {
        System.setProperty("http.maxRedirects", "5");
    }

    public static class HttpResult {
        public final int code;
        public final String content;
        private final Map<String, String> respHeaders;

        public HttpResult(int code, String content, Map<String, String> respHeaders) {
            this.code = code;
            this.content = content;
            this.respHeaders = respHeaders;
        }

        public String getHeader(String name) {
            return this.respHeaders.get(name);
        }
    }
}

