/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.util.LRUCache;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class WallProvider {
    private static final Object PRESENT = new Object();
    private LinkedHashMap<String, Object> whiteList;
    private int whileListMaxSize = 1024;
    private int whiteSqlMaxLength = 1024;
    protected final WallConfig config;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ThreadLocal<Boolean> privileged = new ThreadLocal();

    public WallProvider(WallConfig config) {
        this.config = config;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhiteSql(String sql) {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList == null) {
                this.whiteList = new LRUCache<String, Object>(this.whileListMaxSize);
            }
            this.whiteList.put(sql, PRESENT);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWhiteList() {
        HashSet<String> hashSet = new HashSet<String>();
        this.lock.readLock().lock();
        try {
            if (this.whiteList != null) {
                hashSet.addAll(this.whiteList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList != null) {
                this.whiteList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean whiteContains(String sql) {
        this.lock.readLock().lock();
        try {
            if (this.whiteList == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.whiteList.get(sql) != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public abstract SQLStatementParser createParser(String var1);

    public abstract WallVisitor createWallVisitor();

    public abstract ExportParameterVisitor createExportParameterVisitor();

    public boolean checkValid(String sql) {
        return this.check(sql).size() == 0;
    }

    public List<Violation> check(String sql) {
        if (privileged.get() == Boolean.TRUE) {
            return Collections.emptyList();
        }
        boolean isWhite = this.whiteContains(sql);
        if (isWhite) {
            return Collections.emptyList();
        }
        SQLStatementParser parser = this.createParser(sql);
        if (!this.config.isCommentAllow()) {
            parser.getLexer().setAllowComment(false);
        }
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        try {
            parser.parseStatementList(statementList);
        }
        catch (Exception e) {
            return Collections.singletonList(new SyntaxErrorViolation(e, sql));
        }
        if (parser.getLexer().token() != Token.EOF) {
            return Collections.singletonList(new IllegalSQLObjectViolation(sql));
        }
        if (statementList.size() == 0) {
            return Collections.emptyList();
        }
        if (statementList.size() > 1 && !this.config.isMultiStatementAllow()) {
            return Collections.singletonList(new IllegalSQLObjectViolation(sql));
        }
        SQLStatement stmt = (SQLStatement)statementList.get(0);
        WallVisitor visitor = this.createWallVisitor();
        try {
            stmt.accept(visitor);
        }
        catch (ParserException e) {
            return Collections.singletonList(new IllegalSQLObjectViolation(sql));
        }
        if (visitor.getViolations().size() == 0 && sql.length() < this.whiteSqlMaxLength) {
            this.addWhiteSql(sql);
        }
        return visitor.getViolations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        privileged.set(Boolean.TRUE);
        try {
            T t = action.run();
            return t;
        }
        finally {
            privileged.set(null);
        }
    }
}

