/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractLoadBalancer;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

@Extension(value="consistentHash")
public class ConsistentHashLoadBalancer
extends AbstractLoadBalancer {
    private ConcurrentHashMap<String, Selector> selectorCache = new ConcurrentHashMap();

    public ConsistentHashLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo doSelect(SofaRequest request, List<ProviderInfo> providerInfos) {
        String interfaceId = request.getInterfaceName();
        String method = request.getMethodName();
        String key = interfaceId + "#" + method;
        int hashcode = providerInfos.hashCode();
        Selector selector = this.selectorCache.get(key);
        if (selector == null || selector.getHashCode() != hashcode) {
            selector = new Selector(interfaceId, method, providerInfos, hashcode);
            this.selectorCache.put(key, selector);
        }
        return selector.select(request);
    }

    private static class Selector {
        private final int hashcode;
        private final String interfaceId;
        private final String method;
        private final TreeMap<Long, ProviderInfo> virtualNodes;

        public Selector(String interfaceId, String method, List<ProviderInfo> actualNodes) {
            this(interfaceId, method, actualNodes, actualNodes.hashCode());
        }

        public Selector(String interfaceId, String method, List<ProviderInfo> actualNodes, int hashcode) {
            this.interfaceId = interfaceId;
            this.method = method;
            this.hashcode = hashcode;
            this.virtualNodes = new TreeMap();
            int num = 128;
            for (ProviderInfo providerInfo : actualNodes) {
                for (int i = 0; i < num / 4; ++i) {
                    byte[] digest = this.messageDigest(providerInfo.getHost() + providerInfo.getPort() + i);
                    for (int h = 0; h < 4; ++h) {
                        long m = this.hash(digest, h);
                        this.virtualNodes.put(m, providerInfo);
                    }
                }
            }
        }

        public ProviderInfo select(SofaRequest request) {
            String key = this.buildKeyOfHash(request.getMethodArgs());
            byte[] digest = this.messageDigest(key);
            return this.selectForKey(this.hash(digest, 0));
        }

        private String buildKeyOfHash(Object[] args) {
            if (CommonUtils.isEmpty(args)) {
                return "";
            }
            return StringUtils.toString(args[0]);
        }

        private ProviderInfo selectForKey(long hash) {
            ProviderInfo providerInfo = this.virtualNodes.get(hash);
            if (providerInfo == null) {
                SortedMap<Long, ProviderInfo> tailMap = this.virtualNodes.tailMap(hash);
                hash = tailMap.isEmpty() ? this.virtualNodes.firstKey().longValue() : tailMap.firstKey().longValue();
                providerInfo = this.virtualNodes.get(hash);
            }
            return providerInfo;
        }

        private byte[] messageDigest(String value) {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(value.getBytes("UTF-8"));
                return md5.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SofaRpcRuntimeException("No such algorithm named md5", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new SofaRpcRuntimeException("Unsupported encoding of" + value, e);
            }
        }

        private long hash(byte[] digest, int index) {
            long f = (long)(digest[3 + index * 4] & 0xFF) << 24 | (long)(digest[2 + index * 4] & 0xFF) << 16 | (long)(digest[1 + index * 4] & 0xFF) << 8 | (long)(digest[index * 4] & 0xFF);
            return f & 0xFFFFFFFFL;
        }

        public int getHashCode() {
            return this.hashcode;
        }
    }
}

