/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.protobuf;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.google.protobuf.MessageLite;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class ProtobufHelper {
    private static final boolean MULTIPLE_CLASSLOADER = RpcConfigs.getBooleanValue("multiple.classloader.enable");
    ConcurrentHashMap<Class, Method> parseFromMethodMap = new ConcurrentHashMap();
    ConcurrentHashMap<Class, Method> toByteArrayMethodMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Class> requestClassCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Class> responseClassCache = new ConcurrentHashMap();

    public Class getReqClass(String service, String methodName) {
        String key = this.buildMethodKey(service, methodName);
        Class reqClass = this.requestClassCache.get(key);
        if (reqClass == null) {
            String interfaceClass = ConfigUniqueNameGenerator.getInterfaceName(service);
            Class clazz = ClassUtils.forName(interfaceClass, true);
            this.loadProtoClassToCache(key, clazz, methodName);
        }
        return this.requestClassCache.get(key);
    }

    public Class getResClass(String service, String methodName) {
        String key = service + "#" + methodName;
        Class reqClass = this.responseClassCache.get(key);
        if (reqClass == null) {
            String interfaceClass = ConfigUniqueNameGenerator.getInterfaceName(service);
            Class clazz = ClassUtils.forName(interfaceClass, true);
            this.loadProtoClassToCache(key, clazz, methodName);
        }
        return this.responseClassCache.get(key);
    }

    private String buildMethodKey(String serviceName, String methodName) {
        return serviceName + "#" + methodName;
    }

    private void loadProtoClassToCache(String key, Class clazz, String methodName) {
        Method[] methods;
        Method pbMethod = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            pbMethod = method;
            break;
        }
        if (pbMethod == null) {
            throw new SofaRpcRuntimeException("Cannot found protobuf method: " + clazz.getName() + "." + methodName);
        }
        Class<?>[] parameterTypes = pbMethod.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length != 1 || this.isProtoBufMessageObject(parameterTypes[0])) {
            throw new SofaRpcRuntimeException("class based protobuf: " + clazz.getName() + ", only support one protobuf parameter!");
        }
        Class<?> reqClass = parameterTypes[0];
        this.requestClassCache.put(key, reqClass);
        Class<?> resClass = pbMethod.getReturnType();
        if (resClass == Void.TYPE || !this.isProtoBufMessageClass(resClass)) {
            throw new SofaRpcRuntimeException("class based protobuf: " + clazz.getName() + ", only support return protobuf message!");
        }
        this.responseClassCache.put(key, resClass);
    }

    boolean isProtoBufMessageObject(Object object) {
        if (object == null) {
            return false;
        }
        if (MULTIPLE_CLASSLOADER) {
            return object instanceof MessageLite || this.isProtoBufMessageClass(object.getClass());
        }
        return object instanceof MessageLite;
    }

    boolean isProtoBufMessageClass(Class clazz) {
        return clazz != null && ClassUtils.isAssignableFrom(MessageLite.class, clazz);
    }
}

