/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian;

import com.alipay.hessian.ClassNameFilter;
import com.alipay.hessian.ClassNameResolver;
import com.alipay.hessian.NameBlackListFilter;
import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.sofahessian.BlackListFileLoader;
import com.alipay.sofa.rpc.codec.sofahessian.GenericMultipleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.GenericSingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.MultipleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.SingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SofaConfigs;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayInputStream;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayOutputStream;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteStreamWrapperByteBuf;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

@Extension(value="hessian2", code=1)
public class SofaHessianSerializer
extends AbstractSerializer {
    protected SerializerFactory serializerFactory;
    protected SerializerFactory genericSerializerFactory;

    public SofaHessianSerializer() {
        boolean enableMultipleClassLoader = RpcConfigs.getBooleanValue("multiple.classloader.enable");
        this.serializerFactory = this.getSerializerFactory(enableMultipleClassLoader, false);
        this.genericSerializerFactory = this.getSerializerFactory(enableMultipleClassLoader, true);
        if (RpcConfigs.getBooleanValue("serialize.blacklist.enable") && SofaConfigs.getBooleanValue("rpc_tr_serialize_blacklist", true)) {
            ClassNameResolver resolver = new ClassNameResolver();
            resolver.addFilter((ClassNameFilter)new NameBlackListFilter(BlackListFileLoader.SOFA_SERIALIZE_BLACK_LIST, 8192));
            this.serializerFactory.setClassNameResolver(resolver);
            this.genericSerializerFactory.setClassNameResolver(resolver);
        }
    }

    protected SerializerFactory getSerializerFactory(boolean multipleClassLoader, boolean generic) {
        if (generic) {
            return multipleClassLoader ? new GenericMultipleClassLoaderSofaSerializerFactory() : new GenericSingleClassLoaderSofaSerializerFactory();
        }
        return multipleClassLoader ? new MultipleClassLoaderSofaSerializerFactory() : new SingleClassLoaderSofaSerializerFactory();
    }

    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) {
        if (object instanceof SofaRequest) {
            return this.encodeSofaRequest((SofaRequest)object, context);
        }
        if (object instanceof SofaResponse) {
            return this.encodeSofaResponse((SofaResponse)object, context);
        }
        UnsafeByteArrayOutputStream byteArray = new UnsafeByteArrayOutputStream();
        Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
        try {
            output.setSerializerFactory(this.serializerFactory);
            output.writeObject(object);
            output.close();
            return new ByteStreamWrapperByteBuf(byteArray);
        }
        catch (Exception e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
    }

    protected AbstractByteBuf encodeSofaRequest(SofaRequest sofaRequest, Map<String, String> context) {
        try {
            boolean genericSerialize;
            UnsafeByteArrayOutputStream outputStream = new UnsafeByteArrayOutputStream();
            Hessian2Output output = new Hessian2Output((OutputStream)outputStream);
            boolean bl = genericSerialize = context != null && this.isGenericRequest(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                output.setSerializerFactory(this.genericSerializerFactory);
            } else {
                output.setSerializerFactory(this.serializerFactory);
            }
            output.writeObject((Object)sofaRequest);
            Object[] args = sofaRequest.getMethodArgs();
            if (args != null) {
                for (Object arg : args) {
                    output.writeObject(arg);
                }
            }
            output.close();
            return new ByteStreamWrapperByteBuf(outputStream);
        }
        catch (IOException e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
    }

    protected AbstractByteBuf encodeSofaResponse(SofaResponse response, Map<String, String> context) {
        try {
            UnsafeByteArrayOutputStream byteArray = new UnsafeByteArrayOutputStream();
            Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
            output.setSerializerFactory(this.serializerFactory);
            output.writeObject((Object)response);
            output.close();
            return new ByteStreamWrapperByteBuf(byteArray);
        }
        catch (IOException e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        if (clazz == null) {
            throw this.buildDeserializeError("class is null!");
        }
        if (SofaRequest.class.equals((Object)clazz)) {
            return this.decodeSofaRequest(data, context);
        }
        if (SofaResponse.class.equals((Object)clazz)) {
            return this.decodeSofaResponse(data, context);
        }
        try {
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            input.close();
            return object;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        if (template == null) {
            throw this.buildDeserializeError("template is null!");
        }
        if (template instanceof SofaRequest) {
            this.decodeSofaRequestByTemplate(data, context, (SofaRequest)template);
        } else if (template instanceof SofaResponse) {
            this.decodeSofaResponseByTemplate(data, context, (SofaResponse)template);
        } else {
            throw this.buildDeserializeError("Only support decode from SofaRequest and SofaResponse template");
        }
    }

    protected SofaRequest decodeSofaRequest(AbstractByteBuf data, Map<String, String> context) throws SofaRpcException {
        try {
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            SofaRequest sofaRequest = (SofaRequest)object;
            String targetServiceName = sofaRequest.getTargetServiceUniqueName();
            if (targetServiceName == null) {
                throw this.buildDeserializeError("Target service name of request is null!");
            }
            String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetServiceName);
            sofaRequest.setInterfaceName(interfaceName);
            String[] sig = sofaRequest.getMethodArgSigs();
            Class[] classSig = ClassTypeUtils.getClasses(sig);
            Object[] args = new Object[sig.length];
            for (int i = 0; i < sofaRequest.getMethodArgSigs().length; ++i) {
                args[i] = input.readObject(classSig[i]);
            }
            sofaRequest.setMethodArgs(args);
            input.close();
            return sofaRequest;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    protected void decodeSofaRequestByTemplate(AbstractByteBuf data, Map<String, String> context, SofaRequest template) throws SofaRpcException {
        try {
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            SofaRequest tmp = (SofaRequest)object;
            String targetServiceName = tmp.getTargetServiceUniqueName();
            if (targetServiceName == null) {
                throw this.buildDeserializeError("Target service name of request is null!");
            }
            template.setMethodName(tmp.getMethodName());
            template.setMethodArgSigs(tmp.getMethodArgSigs());
            template.setTargetServiceUniqueName(tmp.getTargetServiceUniqueName());
            template.setTargetAppName(tmp.getTargetAppName());
            template.addRequestProps(tmp.getRequestProps());
            String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetServiceName);
            template.setInterfaceName(interfaceName);
            String[] sig = template.getMethodArgSigs();
            Class[] classSig = ClassTypeUtils.getClasses(sig);
            Object[] args = new Object[sig.length];
            for (int i = 0; i < template.getMethodArgSigs().length; ++i) {
                args[i] = input.readObject(classSig[i]);
            }
            template.setMethodArgs(args);
            input.close();
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    protected SofaResponse decodeSofaResponse(AbstractByteBuf data, Map<String, String> context) throws SofaRpcException {
        try {
            Object object;
            boolean genericSerialize;
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            boolean bl = genericSerialize = context != null && this.isGenericResponse(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                input.setSerializerFactory(this.genericSerializerFactory);
                GenericObject genericObject = (GenericObject)input.readObject();
                SofaResponse sofaResponse = new SofaResponse();
                sofaResponse.setErrorMsg((String)genericObject.getField("errorMsg"));
                sofaResponse.setAppResponse(genericObject.getField("appResponse"));
                sofaResponse.setResponseProps((Map)genericObject.getField("responseProps"));
                object = sofaResponse;
            } else {
                input.setSerializerFactory(this.serializerFactory);
                object = input.readObject();
            }
            input.close();
            return (SofaResponse)object;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    protected void decodeSofaResponseByTemplate(AbstractByteBuf data, Map<String, String> context, SofaResponse template) throws SofaRpcException {
        try {
            boolean genericSerialize;
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            boolean bl = genericSerialize = context != null && this.isGenericResponse(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                input.setSerializerFactory(this.genericSerializerFactory);
                GenericObject genericObject = (GenericObject)input.readObject();
                template.setErrorMsg((String)genericObject.getField("errorMsg"));
                template.setAppResponse(genericObject.getField("appResponse"));
                template.setResponseProps((Map)genericObject.getField("responseProps"));
            } else {
                input.setSerializerFactory(this.serializerFactory);
                SofaResponse tmp = (SofaResponse)input.readObject();
                template.setErrorMsg(tmp.getErrorMsg());
                template.setAppResponse(tmp.getAppResponse());
                template.setResponseProps(tmp.getResponseProps());
            }
            input.close();
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    protected boolean isGenericRequest(String serializeType) {
        return serializeType != null && !serializeType.equals("0");
    }

    protected boolean isGenericResponse(String serializeType) {
        return serializeType != null && serializeType.equals("2");
    }
}

