/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.cache;

import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public final class ReflectCache {
    static final ConcurrentHashMap<String, ClassLoader> APPNAME_CLASSLOADER_MAP = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, ClassLoader> SERVICE_CLASSLOADER_MAP = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, Class> CLASS_CACHE = new ConcurrentHashMap();
    static final ConcurrentHashMap<Class, String> TYPE_STR_CACHE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, ConcurrentHashMap<String, Method>> NOT_OVERLOAD_METHOD_CACHE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, ConcurrentHashMap<String, String[]>> NOT_OVERLOAD_METHOD_SIGS_CACHE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, ConcurrentHashMap<String, Method>> OVERLOAD_METHOD_CACHE = new ConcurrentHashMap();

    public static void registerAppClassLoader(String appName, ClassLoader classloader) {
        APPNAME_CLASSLOADER_MAP.put(appName, classloader);
    }

    public static ClassLoader getAppClassLoader(String appName) {
        ClassLoader appClassLoader = APPNAME_CLASSLOADER_MAP.get(appName);
        if (appClassLoader == null) {
            return ClassLoaderUtils.getCurrentClassLoader();
        }
        return appClassLoader;
    }

    public static void registerServiceClassLoader(String serviceUniqueName, ClassLoader classloader) {
        SERVICE_CLASSLOADER_MAP.put(serviceUniqueName, classloader);
    }

    public static ClassLoader getServiceClassLoader(String serviceUniqueName) {
        ClassLoader appClassLoader = SERVICE_CLASSLOADER_MAP.get(serviceUniqueName);
        if (appClassLoader == null) {
            return ClassLoaderUtils.getCurrentClassLoader();
        }
        return appClassLoader;
    }

    public static void putClassCache(String typeStr, Class clazz) {
        CLASS_CACHE.put(typeStr, clazz);
    }

    public static Class getClassCache(String typeStr) {
        return CLASS_CACHE.get(typeStr);
    }

    public static void putTypeStrCache(Class clazz, String typeStr) {
        TYPE_STR_CACHE.put(clazz, typeStr);
    }

    public static String getTypeStrCache(Class clazz) {
        return TYPE_STR_CACHE.get(clazz);
    }

    public static void putMethodCache(String serviceName, Method method) {
        ConcurrentHashMap<String, Method> old;
        ConcurrentHashMap<String, Method> cache = NOT_OVERLOAD_METHOD_CACHE.get(serviceName);
        if (cache == null && (old = NOT_OVERLOAD_METHOD_CACHE.putIfAbsent(serviceName, cache = new ConcurrentHashMap())) != null) {
            cache = old;
        }
        cache.putIfAbsent(method.getName(), method);
    }

    public static Method getMethodCache(String serviceName, String methodName) {
        ConcurrentHashMap<String, Method> methods = NOT_OVERLOAD_METHOD_CACHE.get(serviceName);
        return methods == null ? null : methods.get(methodName);
    }

    public static void invalidateMethodCache(String serviceName) {
        NOT_OVERLOAD_METHOD_CACHE.remove(serviceName);
    }

    public static void putMethodSigsCache(String serviceName, String methodName, String[] argSigs) {
        ConcurrentHashMap<String, String[]> old;
        ConcurrentHashMap<String, Object> cacheSigs = NOT_OVERLOAD_METHOD_SIGS_CACHE.get(serviceName);
        if (cacheSigs == null && (old = NOT_OVERLOAD_METHOD_SIGS_CACHE.putIfAbsent(serviceName, cacheSigs = new ConcurrentHashMap())) != null) {
            cacheSigs = old;
        }
        cacheSigs.putIfAbsent(methodName, argSigs);
    }

    public static String[] getMethodSigsCache(String serviceName, String methodName) {
        ConcurrentHashMap<String, String[]> methods = NOT_OVERLOAD_METHOD_SIGS_CACHE.get(serviceName);
        return methods == null ? null : methods.get(methodName);
    }

    public static void invalidateMethodSigsCache(String serviceName) {
        NOT_OVERLOAD_METHOD_SIGS_CACHE.remove(serviceName);
    }

    public static void putOverloadMethodCache(String serviceName, Method method) {
        ConcurrentHashMap<String, Method> old;
        ConcurrentHashMap<String, Method> cache = OVERLOAD_METHOD_CACHE.get(serviceName);
        if (cache == null && (old = OVERLOAD_METHOD_CACHE.putIfAbsent(serviceName, cache = new ConcurrentHashMap())) != null) {
            cache = old;
        }
        StringBuilder mSigs = new StringBuilder(128);
        mSigs.append(method.getName());
        for (Class<?> paramType : method.getParameterTypes()) {
            mSigs.append(paramType.getName());
        }
        cache.putIfAbsent(mSigs.toString(), method);
    }

    public static Method getOverloadMethodCache(String serviceName, String methodName, String[] methodSigs) {
        ConcurrentHashMap<String, Method> methods = OVERLOAD_METHOD_CACHE.get(serviceName);
        if (methods == null) {
            return null;
        }
        StringBuilder mSigs = new StringBuilder(128);
        mSigs.append(methodName);
        for (String methodSign : methodSigs) {
            mSigs.append(methodSign);
        }
        return methods.get(mSigs.toString());
    }

    public static void invalidateOverloadMethodCache(String serviceName) {
        OVERLOAD_METHOD_CACHE.remove(serviceName);
    }

    static void clearAll() {
        CLASS_CACHE.clear();
        TYPE_STR_CACHE.clear();
        APPNAME_CLASSLOADER_MAP.clear();
        SERVICE_CLASSLOADER_MAP.clear();
        NOT_OVERLOAD_METHOD_CACHE.clear();
        NOT_OVERLOAD_METHOD_SIGS_CACHE.clear();
        OVERLOAD_METHOD_CACHE.clear();
    }
}

