/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.metrics.lookout;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Lookout;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.metrics.lookout.RpcLookout;
import java.util.concurrent.ConcurrentHashMap;

public class RpcLookoutId {
    private volatile Id consumerId;
    private final Object consumerIdLock = new Object();
    private volatile Id providerId;
    private final Object providerIdLock = new Object();
    private final ConcurrentHashMap<String, Id> serverConfigIds = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id getConsumerId() {
        if (this.consumerId == null) {
            Object object = this.consumerIdLock;
            synchronized (object) {
                if (this.consumerId == null) {
                    this.consumerId = Lookout.registry().createId("rpc.consumer.service.stats");
                }
            }
        }
        return this.consumerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id getProviderId() {
        if (this.providerId == null) {
            Object object = this.providerIdLock;
            synchronized (object) {
                if (this.providerId == null) {
                    this.providerId = Lookout.registry().createId("rpc.provider.service.stats");
                }
            }
        }
        return this.providerId;
    }

    public synchronized Id getServerThreadConfigId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.config";
        return this.getId(key);
    }

    public Id getServerThreadPoolActiveCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.active.count";
        return this.getId(key);
    }

    public Id getServerThreadPoolIdleCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.idle.count";
        return this.getId(key);
    }

    public Id getServerThreadPoolQueueSizeId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.queue.size";
        return this.getId(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Id getId(String key) {
        Id lookoutId = this.serverConfigIds.get(key);
        if (lookoutId != null) return lookoutId;
        Class<RpcLookout> clazz = RpcLookout.class;
        synchronized (RpcLookout.class) {
            lookoutId = this.serverConfigIds.get(key);
            if (lookoutId != null) return lookoutId;
            lookoutId = Lookout.registry().createId(key);
            this.serverConfigIds.put(key, lookoutId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return lookoutId;
        }
    }

    public Id removeServerThreadConfigId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.config";
        return this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolActiveCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.active.count";
        return this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolIdleCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.idle.count";
        return this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolQueueSizeId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.queue.size";
        return this.serverConfigIds.remove(key);
    }
}

