/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.zk.AbstractZookeeperObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperRegistryHelper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperConfigObserver
extends AbstractZookeeperObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfigObserver.class);
    private ConcurrentHashMap<AbstractInterfaceConfig, List<ConfigListener>> configListenerMap = new ConcurrentHashMap();

    public void addConfigListener(AbstractInterfaceConfig config, ConfigListener listener) {
        if (listener != null) {
            this.initOrAddList(this.configListenerMap, config, listener);
        }
    }

    public void removeConfigListener(AbstractInterfaceConfig config) {
        this.configListenerMap.remove(config);
    }

    public void updateConfig(AbstractInterfaceConfig config, String configPath, ChildData data) {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                Map<String, String> attribute = ZookeeperRegistryHelper.convertConfigToAttribute(configPath, data, false);
                for (ConfigListener listener : configListeners) {
                    listener.configChanged(attribute);
                }
            }
        }
    }

    public void updateConfigAll(AbstractInterfaceConfig config, String configPath, List<ChildData> currentData) {
        if (CommonUtils.isEmpty(currentData)) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                for (ChildData data : currentData) {
                    LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
                }
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                List<Map<String, String>> attributes = ZookeeperRegistryHelper.convertConfigToAttributes(configPath, currentData);
                for (ConfigListener listener : configListeners) {
                    for (Map<String, String> attribute : attributes) {
                        listener.configChanged(attribute);
                    }
                }
            }
        }
    }

    public void removeConfig(AbstractInterfaceConfig config, String configPath, ChildData data) {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                Map<String, String> attribute = ZookeeperRegistryHelper.convertConfigToAttribute(configPath, data, true);
                for (ConfigListener listener : configListeners) {
                    listener.configChanged(attribute);
                }
            }
        }
    }

    public void addConfig(AbstractInterfaceConfig config, String configPath, ChildData data) {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                Map<String, String> attribute = ZookeeperRegistryHelper.convertConfigToAttribute(configPath, data, false);
                for (ConfigListener listener : configListeners) {
                    listener.configChanged(attribute);
                }
            }
        }
    }
}

