/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer.factory;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.reporter.facade.AbstractReporter;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatValues;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryReporterImpl
extends AbstractReporter {
    private List<String> stats = new ArrayList<String>();
    private SofaTracerStatisticReporter statReporter;
    private Map<StatKey, StatValues> storeDatas = new HashMap<StatKey, StatValues>();

    public MemoryReporterImpl(String digestLog, String digestRollingPolicy, String digestLogReserveConfig, SpanEncoder<SofaTracerSpan> spanEncoder, SofaTracerStatisticReporter statReporter) {
        this.statReporter = statReporter;
    }

    public void doReport(SofaTracerSpan span) {
        this.stats.add(span.toString());
        if (this.statReporter != null) {
            this.statisticReport(span);
        }
    }

    public String getReporterType() {
        return "Memory";
    }

    private void statisticReport(SofaTracerSpan span) {
        this.statReporter.reportStat(span);
        Map datas = null;
        try {
            Field statDatas = MemoryReporterImpl.getDeclaredField(this.statReporter, "statDatas");
            statDatas.setAccessible(true);
            datas = (Map)statDatas.get(this.statReporter);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.storeDatas.putAll(datas);
    }

    public Map<StatKey, StatValues> getStoreDatas() {
        return this.storeDatas;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

