/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer.log.digest;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import java.io.IOException;
import java.util.Map;

public class RpcServerDigestSpanJsonEncoder
implements SpanEncoder<SofaTracerSpan> {
    private JsonStringBuilder jsb = new JsonStringBuilder();

    public String encode(SofaTracerSpan span) throws IOException {
        this.jsb.reset();
        this.jsb.appendBegin("timestamp", (Object)Timestamp.format((long)span.getEndTime()));
        this.appendSlot(this.jsb, span);
        this.jsb.appendEnd();
        return this.jsb.toString();
    }

    public void appendSlot(JsonStringBuilder xsb, SofaTracerSpan span) {
        Map tagsWithBool;
        Map tagsWithNumber;
        SofaTracerSpanContext spanContext = span.getSofaTracerSpanContext();
        this.jsb.append("tracerId", (Object)spanContext.getTraceId());
        this.jsb.append("spanId", (Object)spanContext.getSpanId());
        Map tagsWithStr = span.getTagsWithStr();
        if (CommonUtils.isNotEmpty(tagsWithStr)) {
            for (Map.Entry entry : tagsWithStr.entrySet()) {
                this.jsb.append((String)entry.getKey(), entry.getValue());
            }
        }
        if (CommonUtils.isNotEmpty(tagsWithNumber = span.getTagsWithNumber())) {
            for (Map.Entry entry : tagsWithNumber.entrySet()) {
                Number value = (Number)entry.getValue();
                this.jsb.append((String)entry.getKey(), (Object)(value == null ? null : String.valueOf(value)));
            }
        }
        if (CommonUtils.isNotEmpty(tagsWithBool = span.getTagsWithBool())) {
            for (Map.Entry entry : tagsWithBool.entrySet()) {
                this.jsb.append((String)entry.getKey(), entry.getValue());
            }
        }
        this.jsb.append("baggage", (Object)this.baggageSerialized(spanContext));
    }

    protected String baggageSerialized(SofaTracerSpanContext spanContext) {
        return spanContext.getBizSerializedBaggage();
    }
}

