/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkhttpProxyInfo;
import okhttp3.ConnectionPool;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class AbstractRequestExecutor<T, E>
implements RequestExecutor<T, E> {
    @Override
    public T execute(RequestHttp requestHttp, String uri, E data) throws WxErrorException, IOException {
        if (requestHttp.getRequestHttpClient() instanceof CloseableHttpClient) {
            CloseableHttpClient httpClient = (CloseableHttpClient)requestHttp.getRequestHttpClient();
            HttpHost httpProxy = (HttpHost)requestHttp.getRequestHttpProxy();
            return this.executeApache(httpClient, httpProxy, uri, data);
        }
        if (requestHttp.getRequestHttpClient() instanceof HttpConnectionProvider) {
            HttpConnectionProvider provider = (HttpConnectionProvider)requestHttp.getRequestHttpClient();
            ProxyInfo proxyInfo = (ProxyInfo)requestHttp.getRequestHttpProxy();
            return this.executeJodd(provider, proxyInfo, uri, data);
        }
        if (requestHttp.getRequestHttpClient() instanceof ConnectionPool) {
            ConnectionPool pool = (ConnectionPool)requestHttp.getRequestHttpClient();
            OkhttpProxyInfo proxyInfo = (OkhttpProxyInfo)requestHttp.getRequestHttpProxy();
            return this.executeOkhttp(pool, proxyInfo, uri, data);
        }
        return null;
    }
}

