/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.AbstractRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkhttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;

public class MediaDownloadRequestExecutor
extends AbstractRequestExecutor<File, String> {
    private File tmpDirFile;

    public MediaDownloadRequestExecutor(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    private String getFileName(HttpResponse response) throws WxErrorException {
        String content = response.header("Content-disposition");
        if (content == null || content.length() == 0) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
        }
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(content);
        if (m.matches()) {
            return m.group(1);
        }
        throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
    }

    private String getFileName(CloseableHttpResponse response) throws WxErrorException {
        Header[] contentDispositionHeader = response.getHeaders("Content-disposition");
        if (contentDispositionHeader == null || contentDispositionHeader.length == 0) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
        }
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(contentDispositionHeader[0].getValue());
        if (m.matches()) {
            return m.group(1);
        }
        throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
    }

    /*
     * Exception decompiling
     */
    @Override
    public File executeApache(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, String queryParam) throws WxErrorException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public File executeJodd(HttpConnectionProvider provider, ProxyInfo proxyInfo, String uri, String queryParam) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        HttpRequest request = HttpRequest.get((String)uri);
        if (proxyInfo != null) {
            provider.useProxy(proxyInfo);
        }
        request.withConnectionProvider(provider);
        HttpResponse response = request.send();
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.bodyText()));
        }
        String fileName = this.getFileName(response);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.bodyBytes());
        String[] nameAndExt = fileName.split("\\.");
        return FileUtils.createTmpFile(inputStream, nameAndExt[0], nameAndExt[1], this.tmpDirFile);
    }

    @Override
    public File executeOkhttp(ConnectionPool pool, final OkhttpProxyInfo proxyInfo, String uri, String queryParam) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(pool);
        if (proxyInfo != null) {
            clientBuilder.proxy(proxyInfo.getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)proxyInfo.getProxyUsername(), (String)proxyInfo.getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        Request request = new Request.Builder().url(uri).get().build();
        Response response = client.newCall(request).execute();
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.body().toString()));
        }
        String fileName = this.getFileName(response);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.body().bytes());
        String[] nameAndExt = fileName.split("\\.");
        return FileUtils.createTmpFile(inputStream, nameAndExt[0], nameAndExt[1], this.tmpDirFile);
    }

    private String getFileName(Response response) throws WxErrorException {
        String content = response.header("Content-disposition");
        if (content == null || content.length() == 0) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
        }
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(content);
        if (m.matches()) {
            return m.group(1);
        }
        throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
    }
}

