/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.net.InetSocketAddress;
import java.net.Proxy;

public class OkhttpProxyInfo {
    private final String proxyAddress;
    private final int proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private final ProxyType proxyType;

    public OkhttpProxyInfo(ProxyType proxyType, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.proxyType = proxyType;
        this.proxyAddress = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    public static OkhttpProxyInfo directProxy() {
        return new OkhttpProxyInfo(ProxyType.NONE, null, 0, null, null);
    }

    public static OkhttpProxyInfo socks4Proxy(String proxyAddress, int proxyPort, String proxyUser) {
        return new OkhttpProxyInfo(ProxyType.SOCKS4, proxyAddress, proxyPort, proxyUser, null);
    }

    public static OkhttpProxyInfo socks5Proxy(String proxyAddress, int proxyPort, String proxyUser, String proxyPassword) {
        return new OkhttpProxyInfo(ProxyType.SOCKS5, proxyAddress, proxyPort, proxyUser, proxyPassword);
    }

    public static OkhttpProxyInfo httpProxy(String proxyAddress, int proxyPort, String proxyUser, String proxyPassword) {
        return new OkhttpProxyInfo(ProxyType.HTTP, proxyAddress, proxyPort, proxyUser, proxyPassword);
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public Proxy getProxy() {
        Proxy proxy = null;
        if (this.getProxyType().equals((Object)ProxyType.SOCKS5)) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.getProxyAddress(), this.getProxyPort()));
        } else if (this.getProxyType().equals((Object)ProxyType.SOCKS4)) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.getProxyAddress(), this.getProxyPort()));
        } else if (this.getProxyType().equals((Object)ProxyType.HTTP)) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyAddress(), this.getProxyPort()));
        } else if (this.getProxyType().equals((Object)ProxyType.NONE)) {
            proxy = new Proxy(Proxy.Type.DIRECT, new InetSocketAddress(this.getProxyAddress(), this.getProxyPort()));
        }
        return proxy;
    }

    public static enum ProxyType {
        NONE,
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

