/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.ecommerce.SignatureHeader;
import com.github.binarywang.wxpay.bean.marketing.FavorCallbacksSaveRequest;
import com.github.binarywang.wxpay.bean.marketing.FavorCallbacksSaveResult;
import com.github.binarywang.wxpay.bean.marketing.FavorCouponsCreateRequest;
import com.github.binarywang.wxpay.bean.marketing.FavorCouponsCreateResult;
import com.github.binarywang.wxpay.bean.marketing.FavorCouponsGetResult;
import com.github.binarywang.wxpay.bean.marketing.FavorCouponsQueryRequest;
import com.github.binarywang.wxpay.bean.marketing.FavorCouponsQueryResult;
import com.github.binarywang.wxpay.bean.marketing.FavorCouponsUseResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksCreateRequest;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksCreateResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksFlowGetResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksGetResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksItemsGetResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksMerchantsGetResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksPauseResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksQueryRequest;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksQueryResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksRestartResult;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksSetRequest;
import com.github.binarywang.wxpay.bean.marketing.FavorStocksStartResult;
import com.github.binarywang.wxpay.bean.marketing.UseNotifyData;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.MarketingFavorService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketingFavorServiceImpl
implements MarketingFavorService {
    private static final Logger log = LoggerFactory.getLogger(MarketingFavorServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public FavorStocksCreateResult createFavorStocksV3(FavorStocksCreateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/coupon-stocks", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (FavorStocksCreateResult)GSON.fromJson(result, FavorStocksCreateResult.class);
    }

    @Override
    public FavorCouponsCreateResult createFavorCouponsV3(String openid, FavorCouponsCreateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/users/%s/coupons", this.payService.getPayBaseUrl(), openid);
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (FavorCouponsCreateResult)GSON.fromJson(result, FavorCouponsCreateResult.class);
    }

    @Override
    public FavorStocksStartResult startFavorStocksV3(String stockId, FavorStocksSetRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/start", this.payService.getPayBaseUrl(), stockId);
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (FavorStocksStartResult)GSON.fromJson(result, FavorStocksStartResult.class);
    }

    @Override
    public FavorStocksQueryResult queryFavorStocksV3(FavorStocksQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks", this.payService.getPayBaseUrl());
        String query = String.format("?offset=%s&limit=%s&stock_creator_mchid=%s", request.getOffset(), request.getLimit(), request.getStockCreatorMchid());
        if (StringUtils.isNotBlank((CharSequence)request.getCreateStartTime())) {
            query = query + "&create_start_time=" + request.getCreateStartTime();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCreateEndTime())) {
            query = query + "&create_end_time=" + request.getCreateEndTime();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getStatus())) {
            query = query + "&status=" + request.getStatus();
        }
        String result = this.payService.getV3(url + query);
        return (FavorStocksQueryResult)GSON.fromJson(result, FavorStocksQueryResult.class);
    }

    @Override
    public FavorStocksGetResult getFavorStocksV3(String stockId, String stockCreatorMchid) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s", this.payService.getPayBaseUrl(), stockId);
        String query = String.format("?stock_creator_mchid=%s", stockCreatorMchid);
        String result = this.payService.getV3(url + query);
        return (FavorStocksGetResult)GSON.fromJson(result, FavorStocksGetResult.class);
    }

    @Override
    public FavorCouponsGetResult getFavorCouponsV3(String couponId, String appid, String openid) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/users/%s/coupons/%s", this.payService.getPayBaseUrl(), openid, couponId);
        String query = String.format("?appid=%s", appid);
        String result = this.payService.getV3(url + query);
        return (FavorCouponsGetResult)GSON.fromJson(result, FavorCouponsGetResult.class);
    }

    @Override
    public FavorStocksMerchantsGetResult getFavorStocksMerchantsV3(String stockId, String stockCreatorMchid, Integer offset, Integer limit) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/merchants", this.payService.getPayBaseUrl(), stockId);
        String query = String.format("?stock_creator_mchid=%s&offset=%s&limit=%s", stockCreatorMchid, offset, limit);
        String result = this.payService.getV3(url + query);
        return (FavorStocksMerchantsGetResult)GSON.fromJson(result, FavorStocksMerchantsGetResult.class);
    }

    @Override
    public FavorStocksItemsGetResult getFavorStocksItemsV3(String stockId, String stockCreatorMchid, Integer offset, Integer limit) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/items", this.payService.getPayBaseUrl(), stockId);
        String query = String.format("?stock_creator_mchid=%s&offset=%s&limit=%s", stockCreatorMchid, offset, limit);
        String result = this.payService.getV3(url + query);
        return (FavorStocksItemsGetResult)GSON.fromJson(result, FavorStocksItemsGetResult.class);
    }

    @Override
    public FavorCouponsQueryResult queryFavorCouponsV3(FavorCouponsQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/users/%s/coupons", this.payService.getPayBaseUrl(), request.getOpenid());
        String query = String.format("?appid=%s", request.getAppid());
        if (StringUtils.isNotBlank((CharSequence)request.getStockId())) {
            query = query + "&stock_id=" + request.getStockId();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getStatus())) {
            query = query + "&status=" + request.getStatus();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCreatorMchid())) {
            query = query + "&creator_mchid=" + request.getCreatorMchid();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSenderMchid())) {
            query = query + "&sender_mchid=" + request.getSenderMchid();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getAvailableMchid())) {
            query = query + "&available_mchid=" + request.getAvailableMchid();
        }
        if (request.getOffset() != null) {
            query = query + "&offset=" + request.getOffset();
        }
        if (request.getLimit() != null) {
            query = query + "&limit=" + request.getLimit();
        }
        String result = this.payService.getV3(url + query);
        return (FavorCouponsQueryResult)GSON.fromJson(result, FavorCouponsQueryResult.class);
    }

    @Override
    public FavorStocksFlowGetResult getFavorStocksUseFlowV3(String stockId) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/use-flow", this.payService.getPayBaseUrl(), stockId);
        String result = this.payService.getV3(url);
        return (FavorStocksFlowGetResult)GSON.fromJson(result, FavorStocksFlowGetResult.class);
    }

    @Override
    public FavorStocksFlowGetResult getFavorStocksRefundFlowV3(String stockId) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/refund-flow", this.payService.getPayBaseUrl(), stockId);
        String result = this.payService.getV3(url);
        return (FavorStocksFlowGetResult)GSON.fromJson(result, FavorStocksFlowGetResult.class);
    }

    @Override
    public FavorCallbacksSaveResult saveFavorCallbacksV3(FavorCallbacksSaveRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/callbacks", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (FavorCallbacksSaveResult)GSON.fromJson(result, FavorCallbacksSaveResult.class);
    }

    @Override
    public FavorStocksPauseResult pauseFavorStocksV3(String stockId, FavorStocksSetRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/pause", this.payService.getPayBaseUrl(), stockId);
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (FavorStocksPauseResult)GSON.fromJson(result, FavorStocksPauseResult.class);
    }

    @Override
    public FavorStocksRestartResult restartFavorStocksV3(String stockId, FavorStocksSetRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/favor/stocks/%s/restart", this.payService.getPayBaseUrl(), stockId);
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (FavorStocksRestartResult)GSON.fromJson(result, FavorStocksRestartResult.class);
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s\n%s\n%s\n", header.getTimeStamp(), header.getNonce(), data);
        return this.payService.getConfig().getVerifier().verify(header.getSerialNo(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSigned());
    }

    @Override
    public UseNotifyData parseNotifyData(String data, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, data)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        return (UseNotifyData)GSON.fromJson(data, UseNotifyData.class);
    }

    @Override
    public FavorCouponsUseResult decryptNotifyDataResource(UseNotifyData data) throws WxPayException {
        UseNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return (FavorCouponsUseResult)GSON.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key), FavorCouponsUseResult.class);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    public MarketingFavorServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

