/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.AbstractGraphMojo;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.DependencyNodeIdRenderer;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.MavenGraphAdapter;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.dependency.SimpleGraphFactory;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.EnumSet;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="graph", defaultPhase=LifecyclePhase.NONE, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class DependencyGraphMojo
extends AbstractGraphMojo {
    @Parameter(property="showGroupIds", defaultValue="false")
    private boolean showGroupIds;
    @Parameter(property="showVersions", defaultValue="false")
    private boolean showVersions;
    @Parameter(property="showTypes", defaultValue="false")
    private boolean showTypes;
    @Parameter(property="showClassifiers", defaultValue="false")
    private boolean showClassifiers;
    @Parameter(property="showConflicts", defaultValue="false")
    private boolean showConflicts;
    @Parameter(property="showDuplicates", defaultValue="false")
    private boolean showDuplicates;
    @Parameter(property="mergeTypes", defaultValue="false")
    private boolean mergeTypes;
    @Parameter(property="mergeClassifiers", defaultValue="false")
    private boolean mergeClassifiers;

    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, GraphStyleConfigurer graphStyleConfigurer) {
        this.handleOptionsForFullGraph();
        GraphBuilder<DependencyNode> graphBuilder = this.createGraphBuilder(graphStyleConfigurer);
        MavenGraphAdapter adapter = this.createMavenGraphAdapter(transitiveIncludeExcludeFilter, targetFilter);
        return new SimpleGraphFactory(adapter, globalFilter, graphBuilder);
    }

    GraphBuilder<DependencyNode> createGraphBuilder(GraphStyleConfigurer graphStyleConfigurer) {
        DependencyNodeIdRenderer nodeIdRenderer = DependencyNodeIdRenderer.versionlessId().withClassifier(!this.mergeClassifiers).withType(!this.mergeTypes);
        return graphStyleConfigurer.showGroupIds(this.showGroupIds).showArtifactIds(true).showTypes(this.showTypes).showClassifiers(this.showClassifiers).showVersionsOnNodes(this.showVersions).showVersionsOnEdges(this.showVersions && this.requiresFullGraph()).configure(GraphBuilder.create(nodeIdRenderer));
    }

    private void handleOptionsForFullGraph() {
        if (this.showFullGraph()) {
            this.showGroupIds = true;
            this.showVersions = true;
            this.showClassifiers = true;
            this.showTypes = true;
        }
    }

    private MavenGraphAdapter createMavenGraphAdapter(ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter) {
        MavenGraphAdapter adapter;
        if (this.requiresFullGraph()) {
            EnumSet<NodeResolution> resolutions = EnumSet.allOf(NodeResolution.class);
            resolutions = !this.showConflicts ? EnumSet.complementOf(EnumSet.of(NodeResolution.OMITTED_FOR_CONFLICT)) : resolutions;
            resolutions = !this.showDuplicates ? EnumSet.complementOf(EnumSet.of(NodeResolution.OMITTED_FOR_DUPLICATE)) : resolutions;
            adapter = new MavenGraphAdapter(this.dependencyTreeBuilder, this.localRepository, transitiveIncludeExcludeFilter, targetFilter, resolutions);
        } else {
            adapter = new MavenGraphAdapter(this.dependencyGraphBuilder, transitiveIncludeExcludeFilter, targetFilter, false);
        }
        return adapter;
    }

    private boolean requiresFullGraph() {
        return this.showConflicts || this.showDuplicates;
    }
}

