/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.MavenGraphAdapter;
import com.github.ferstl.depgraph.dependency.SubProjectSupplier;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;

public class AggregatingGraphFactory
implements GraphFactory {
    private final MavenGraphAdapter mavenGraphAdapter;
    private final SubProjectSupplier subProjectSupplier;
    private final ArtifactFilter globalFilter;
    private final GraphBuilder<DependencyNode> graphBuilder;
    private final boolean includeParentProjects;

    public AggregatingGraphFactory(MavenGraphAdapter mavenGraphAdapter, SubProjectSupplier subProjectSupplier, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder, boolean includeParentProjects) {
        this.mavenGraphAdapter = mavenGraphAdapter;
        this.subProjectSupplier = subProjectSupplier;
        this.globalFilter = globalFilter;
        this.graphBuilder = graphBuilder;
        this.includeParentProjects = includeParentProjects;
    }

    @Override
    public String createGraph(MavenProject parent) {
        this.graphBuilder.graphName(parent.getArtifactId());
        if (this.includeParentProjects) {
            this.buildModuleTree(parent, this.graphBuilder);
        }
        Collection<MavenProject> collectedProjects = this.subProjectSupplier.getSubProjects(parent);
        for (MavenProject collectedProject : collectedProjects) {
            if (!this.isPartOfGraph(collectedProject)) continue;
            this.mavenGraphAdapter.buildDependencyGraph(collectedProject, this.globalFilter, this.graphBuilder);
        }
        Artifact artifact = parent.getArtifact();
        if (this.graphBuilder.isEmpty() && this.globalFilter.include(artifact)) {
            this.graphBuilder.addNode(new DependencyNode(artifact));
        }
        return this.graphBuilder.toString();
    }

    private void buildModuleTree(MavenProject parentProject, GraphBuilder<DependencyNode> graphBuilder) {
        List collectedProjects = parentProject.getCollectedProjects();
        Iterator iterator = collectedProjects.iterator();
        block0: while (iterator.hasNext()) {
            MavenProject collectedProject;
            MavenProject child = collectedProject = (MavenProject)iterator.next();
            for (MavenProject parent = collectedProject.getParent(); parent != null; parent = parent.getParent()) {
                DependencyNode parentNode = this.filterProject(parent);
                DependencyNode childNode = this.filterProject(child);
                graphBuilder.addEdge(parentNode, childNode);
                if (parent.equals((Object)parentProject)) continue block0;
                child = parent;
            }
        }
    }

    private boolean isPartOfGraph(MavenProject project) {
        boolean isIncluded = this.globalFilter.include(project.getArtifact());
        if (isIncluded && project.getModules().size() > 0) {
            return this.includeParentProjects;
        }
        return isIncluded;
    }

    private DependencyNode filterProject(MavenProject project) {
        Artifact artifact = project.getArtifact();
        if (this.globalFilter.include(artifact)) {
            return new DependencyNode(artifact);
        }
        return null;
    }
}

