/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;

public final class DependencyNode {
    private org.apache.maven.shared.dependency.tree.DependencyNode treeNode;
    private final Artifact artifact;
    private final NodeResolution resolution;
    private final Set<String> scopes;
    private final Set<String> classifiers;
    private final Set<String> types;

    public DependencyNode(Artifact artifact) {
        this(artifact, NodeResolution.INCLUDED);
    }

    public DependencyNode(org.apache.maven.shared.dependency.graph.DependencyNode dependencyNode) {
        this(dependencyNode.getArtifact());
    }

    public DependencyNode(org.apache.maven.shared.dependency.tree.DependencyNode dependencyNode) {
        this(dependencyNode.getArtifact(), DependencyNode.determineResolution(dependencyNode.getState()));
        this.treeNode = dependencyNode;
    }

    private DependencyNode(Artifact artifact, NodeResolution resolution) {
        if (artifact == null) {
            throw new NullPointerException("Artifact must not be null");
        }
        if (artifact.getScope() == null) {
            artifact.setScope("compile");
        }
        this.scopes = new TreeSet<String>();
        this.classifiers = new TreeSet<String>();
        this.types = new TreeSet<String>();
        this.artifact = artifact;
        this.resolution = resolution;
        this.scopes.add(artifact.getScope());
        this.types.add(artifact.getType());
        if (!Strings.isNullOrEmpty((String)artifact.getClassifier())) {
            this.classifiers.add(artifact.getClassifier());
        }
    }

    public void merge(DependencyNode other) {
        if (this == other) {
            return;
        }
        this.scopes.addAll(other.scopes);
        this.classifiers.addAll(other.classifiers);
        this.types.addAll(other.types);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public NodeResolution getResolution() {
        return this.resolution;
    }

    public Set<String> getScopes() {
        return ImmutableSet.copyOf(this.scopes);
    }

    public Set<String> getClassifiers() {
        return ImmutableSet.copyOf(this.classifiers);
    }

    public Set<String> getTypes() {
        return ImmutableSet.copyOf(this.types);
    }

    public String getEffectiveVersion() {
        if (this.treeNode == null || this.treeNode.getRelatedArtifact() == null) {
            return this.artifact.getVersion();
        }
        return this.treeNode.getRelatedArtifact().getVersion();
    }

    public String getEffectiveScope() {
        if (this.scopes.size() > 0) {
            return this.scopes.iterator().next();
        }
        return null;
    }

    public String toString() {
        return this.artifact.toString();
    }

    private static NodeResolution determineResolution(int res) {
        switch (res) {
            case 1: {
                return NodeResolution.OMITTED_FOR_DUPLICATE;
            }
            case 2: {
                return NodeResolution.OMITTED_FOR_CONFLICT;
            }
            case 3: {
                return NodeResolution.OMITTED_FOR_CYCLE;
            }
        }
        return NodeResolution.INCLUDED;
    }
}

