/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.gml;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.google.common.base.Joiner;
import java.util.LinkedHashSet;
import java.util.Set;

public class GmlDependencyNodeNameRenderer
implements NodeRenderer<DependencyNode> {
    private static final Joiner NEWLINE_JOINER = Joiner.on((String)"\n").skipNulls();
    private static final Joiner SLASH_JOINER = Joiner.on((String)"/").skipNulls();
    private final boolean showGroupId;
    private final boolean showArtifactId;
    private final boolean showTypes;
    private final boolean showClassifiers;
    private final boolean showVersion;

    public GmlDependencyNodeNameRenderer(boolean showGroupId, boolean showArtifactId, boolean showTypes, boolean showClassifiers, boolean showVersion) {
        this.showGroupId = showGroupId;
        this.showArtifactId = showArtifactId;
        this.showTypes = showTypes;
        this.showClassifiers = showClassifiers;
        this.showVersion = showVersion;
    }

    @Override
    public String render(DependencyNode node) {
        String content = NEWLINE_JOINER.join((Object)(this.showGroupId ? node.getArtifact().getGroupId() : null), (Object)(this.showArtifactId ? node.getArtifact().getArtifactId() : null), new Object[]{this.showVersion ? node.getEffectiveVersion() : null, this.showTypes ? GmlDependencyNodeNameRenderer.createTypeString(node.getTypes()) : null, this.showClassifiers ? GmlDependencyNodeNameRenderer.createClassifierString(node.getClassifiers()) : null, GmlDependencyNodeNameRenderer.createScopeString(node.getScopes())});
        if (content.isEmpty()) {
            return "";
        }
        return "label \"" + content + "\"";
    }

    private static String createTypeString(Set<String> types) {
        if (types.size() > 1 || !types.contains("jar")) {
            LinkedHashSet<String> typesToDisplay = new LinkedHashSet<String>(types.size());
            for (String type : types) {
                typesToDisplay.add("." + type);
            }
            return SLASH_JOINER.join(typesToDisplay);
        }
        return "";
    }

    private static String createScopeString(Set<String> scopes) {
        if (scopes.size() > 1 || !scopes.contains("compile")) {
            return "(" + SLASH_JOINER.join(scopes) + ")";
        }
        return null;
    }

    private static String createClassifierString(Set<String> classifiers) {
        return SLASH_JOINER.join(classifiers);
    }
}

