/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.puml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class PumlNodeInfo {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String component;
    private String label;
    private String stereotype;

    PumlNodeInfo() {
    }

    @JsonCreator
    public PumlNodeInfo(@JsonProperty(value="component") String component, @JsonProperty(value="label") String label, @JsonProperty(value="stereotype") String stereotype) {
        this.component = component;
        this.label = label;
        this.stereotype = stereotype;
    }

    public String getComponent() {
        return this.component;
    }

    public String getLabel() {
        return this.label;
    }

    public String getStereotype() {
        return this.stereotype;
    }

    public PumlNodeInfo withComponent(String component) {
        this.component = component;
        return this;
    }

    public PumlNodeInfo withLabel(String label) {
        this.label = label;
        return this;
    }

    public PumlNodeInfo withStereotype(String stereotype) {
        this.stereotype = stereotype;
        return this;
    }

    public static PumlNodeInfo parse(String serialized) {
        try {
            return (PumlNodeInfo)OBJECT_MAPPER.readValue(serialized, PumlNodeInfo.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse PUML node info from: " + serialized, e);
        }
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot serialize PUML node info", e);
        }
    }
}

