/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.PropertyInfo;
import jetbrick.util.Validate;

public final class BeanMap
implements Map<String, Object> {
    private final KlassInfo klass;
    private final Object object;

    public BeanMap(Object object) {
        Validate.notNull(object);
        this.klass = KlassInfo.create(object.getClass());
        this.object = object;
    }

    @Override
    public int size() {
        return this.klass.getProperties().size();
    }

    @Override
    public boolean isEmpty() {
        return this.klass.getProperties().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.klass.getProperty((String)key) != null;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        PropertyInfo prop;
        if (key instanceof String && (prop = this.klass.getProperty((String)key)) != null) {
            return prop.get(this.object);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        PropertyInfo prop = this.klass.getProperty(key);
        if (prop != null) {
            Object old = prop.get(this.object);
            prop.set(this.object, value);
            return old;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (PropertyInfo prop : this.klass.getProperties()) {
            set.add(prop.getName());
        }
        return set;
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }
}

