/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.ParameterInfo;
import jetbrick.util.ArrayUtils;
import jetbrick.util.concurrent.ConcurrentInitializer;
import jetbrick.util.concurrent.LazyInitializer;

public abstract class Executable {
    private final ConcurrentInitializer<List<ParameterInfo>> parametersGetter = new LazyInitializer<List<ParameterInfo>>(){

        @Override
        protected List<ParameterInfo> initialize() {
            Executable object = Executable.this;
            Class<?>[] parameterTypes = object.getParameterTypes();
            if (parameterTypes.length == 0) {
                return Collections.emptyList();
            }
            Type[] genericParameterTypes = object.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = object.getParameterAnnotations();
            ParameterInfo[] parameters = new ParameterInfo[genericParameterTypes.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = new ParameterInfo(object, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i], i);
            }
            return Arrays.asList(parameters);
        }
    };
    private volatile String signature;

    public abstract KlassInfo getDeclaringKlass();

    public abstract String getName();

    public abstract int getOffset();

    public List<ParameterInfo> getParameters() {
        return this.parametersGetter.get();
    }

    public abstract int getParameterCount();

    public abstract Class<?>[] getParameterTypes();

    public abstract Type[] getGenericParameterTypes();

    public Class<?>[] getRawParameterTypes(KlassInfo declaringKlass) {
        return this.getRawParameterTypes(declaringKlass.getType());
    }

    public Class<?>[] getRawParameterTypes(Class<?> declaringClass) {
        List<ParameterInfo> parameters = this.getParameters();
        int size = parameters.size();
        if (size == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            types[i] = parameters.get(i).getRawType(declaringClass);
        }
        return types;
    }

    public abstract boolean isVarArgs();

    public abstract Annotation[] getAnnotations();

    public abstract <T extends Annotation> T getAnnotation(Class<T> var1);

    public abstract <T extends Annotation> boolean isAnnotationPresent(Class<T> var1);

    public abstract Annotation[][] getParameterAnnotations();

    public abstract int getModifiers();

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDeclaringKlass().getType().getName());
            sb.append('#').append(this.getName()).append('(');
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(parameterTypes[i].getName());
            }
            sb.append(')');
            this.signature = sb.toString();
        }
        return this.signature;
    }

    public String toString() {
        return this.getSignature();
    }
}

