/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean.asm;

import java.lang.reflect.Modifier;
import java.util.List;
import jetbrick.asm.ClassWriter;
import jetbrick.asm.Label;
import jetbrick.asm.MethodVisitor;
import jetbrick.asm.Type;
import jetbrick.bean.ConstructorInfo;
import jetbrick.bean.Executable;
import jetbrick.bean.FieldInfo;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.bean.asm.AsmAccessor;

final class AsmBuilder {
    private static final String SUN_MAGIC_ACCESSOR_KLASS = "sun/reflect/MagicAccessorImpl";
    private static final String FIELD_EXPECTED_CONSTRUCTOR_ARGUMENT_LENGTHS = "ctors";
    private static final String FIELD_EXPECTED_METHOD_ARGUMENT_LENGTHS = "methods";
    private static final String METHOD_CHECK_ARGUMENTS = "checkArguments";
    private final ClassWriter cw;
    private final String generatedKlassNameInternal;
    private final String delegateKlassNameInternal;

    public AsmBuilder(String generatedKlassName, String delegateKlassName, Class<?> interfaceKlass) {
        this.generatedKlassNameInternal = generatedKlassName.replace('.', '/');
        this.delegateKlassNameInternal = delegateKlassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        String[] interfaces = new String[]{interfaceKlass.getName().replace('.', '/')};
        this.cw.visit(196653, 49, this.generatedKlassNameInternal, null, SUN_MAGIC_ACCESSOR_KLASS, interfaces);
    }

    public static byte[] create(String generatedKlassName, KlassInfo delegateKlass) {
        AsmBuilder builder = new AsmBuilder(generatedKlassName, delegateKlass.getName(), AsmAccessor.class);
        builder.insertArgumentsLengthField(delegateKlass.getDeclaredConstructors(), delegateKlass.getDeclaredMethods());
        builder.insertCheckArgumentsMethod();
        builder.insertConstructor();
        builder.insertNewInstance();
        builder.insertNewInstance(delegateKlass.getDeclaredConstructors());
        builder.insertInvoke(delegateKlass.getDeclaredMethods());
        builder.insertGetField(delegateKlass.getDeclaredFields());
        builder.insertSetField(delegateKlass.getDeclaredFields());
        return builder.asByteCode();
    }

    public void insertArgumentsLengthField(List<? extends Executable> constructors, List<? extends Executable> methods) {
        int i;
        this.cw.visitField(26, FIELD_EXPECTED_CONSTRUCTOR_ARGUMENT_LENGTHS, "[I", null, null).visitEnd();
        this.cw.visitField(26, FIELD_EXPECTED_METHOD_ARGUMENT_LENGTHS, "[I", null, null).visitEnd();
        MethodVisitor mv = this.cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        int size = constructors.size();
        mv.visitIntInsn(16, size);
        mv.visitIntInsn(188, 10);
        for (i = 0; i < size; ++i) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            mv.visitIntInsn(16, constructors.get(i).getParameterCount());
            mv.visitInsn(79);
        }
        mv.visitFieldInsn(179, this.generatedKlassNameInternal, FIELD_EXPECTED_CONSTRUCTOR_ARGUMENT_LENGTHS, "[I");
        size = methods.size();
        mv.visitIntInsn(16, size);
        mv.visitIntInsn(188, 10);
        for (i = 0; i < size; ++i) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            mv.visitIntInsn(16, methods.get(i).getParameterCount());
            mv.visitInsn(79);
        }
        mv.visitFieldInsn(179, this.generatedKlassNameInternal, FIELD_EXPECTED_METHOD_ARGUMENT_LENGTHS, "[I");
        mv.visitInsn(177);
        mv.visitMaxs(size > 0 ? 4 : 1, 0);
        mv.visitEnd();
    }

    public void insertCheckArgumentsMethod() {
        MethodVisitor mv = this.cw.visitMethod(26, METHOD_CHECK_ARGUMENTS, "([II[Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        Label labelStep2 = new Label();
        Label labelError2 = new Label();
        Label labelStep3 = new Label();
        Label labelSucc = new Label();
        mv.visitVarInsn(25, 2);
        mv.visitJumpInsn(199, labelStep2);
        AsmBuilder.throwIllegalArgumentException(mv, "arguments must be not null");
        mv.visitLabel(labelStep2);
        mv.visitVarInsn(21, 1);
        mv.visitJumpInsn(155, labelError2);
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(190);
        mv.visitJumpInsn(161, labelStep3);
        mv.visitLabel(labelError2);
        AsmBuilder.throwIllegalArgumentException(mv, "wrong offset of member");
        mv.visitLabel(labelStep3);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(190);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(46);
        mv.visitJumpInsn(159, labelSucc);
        AsmBuilder.throwIllegalArgumentException(mv, "wrong number of arguments");
        mv.visitLabel(labelSucc);
        mv.visitInsn(177);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
    }

    public void insertConstructor() {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUN_MAGIC_ACCESSOR_KLASS, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public void insertNewInstance() {
        MethodVisitor mv = this.cw.visitMethod(1, "newInstance", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.delegateKlassNameInternal);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.delegateKlassNameInternal, "<init>", "()V", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public void insertNewInstance(List<ConstructorInfo> constructors) {
        MethodVisitor mv = this.cw.visitMethod(129, "newInstance", "(I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, this.generatedKlassNameInternal, FIELD_EXPECTED_CONSTRUCTOR_ARGUMENT_LENGTHS, "[I");
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, this.generatedKlassNameInternal, METHOD_CHECK_ARGUMENTS, "([II[Ljava/lang/Object;)V", false);
        int n = constructors.size();
        if (n != 0) {
            mv.visitVarInsn(21, 1);
            Label[] labels = new Label[n];
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            StringBuilder buffer = new StringBuilder(128);
            for (int i = 0; i < n; ++i) {
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitTypeInsn(187, this.delegateKlassNameInternal);
                mv.visitInsn(89);
                buffer.setLength(0);
                buffer.append('(');
                Class<?>[] paramTypes = constructors.get(i).getParameterTypes();
                for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
                    mv.visitVarInsn(25, 2);
                    mv.visitIntInsn(16, paramIndex);
                    mv.visitInsn(50);
                    Type type = Type.getType(paramTypes[paramIndex]);
                    AsmBuilder.insertUnbox(mv, type);
                    buffer.append(type.getDescriptor());
                }
                buffer.append(")V");
                mv.visitMethodInsn(183, this.delegateKlassNameInternal, "<init>", buffer.toString(), false);
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        AsmBuilder.throwIllegalArgumentException(mv, "wrong offset of constructor");
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void insertInvoke(List<MethodInfo> methods) {
        MethodVisitor mv = this.cw.visitMethod(129, "invoke", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, this.generatedKlassNameInternal, FIELD_EXPECTED_METHOD_ARGUMENT_LENGTHS, "[I");
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, this.generatedKlassNameInternal, METHOD_CHECK_ARGUMENTS, "([II[Ljava/lang/Object;)V", false);
        int n = methods.size();
        if (n != 0) {
            mv.visitVarInsn(21, 2);
            Label[] labels = new Label[n];
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            StringBuilder buffer = new StringBuilder(128);
            for (int i = 0; i < n; ++i) {
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                MethodInfo method = methods.get(i);
                boolean isInterface = method.getDeclaringKlass().isInterface();
                boolean isStatic = method.isStatic();
                if (!isStatic) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, this.delegateKlassNameInternal);
                }
                buffer.setLength(0);
                buffer.append('(');
                String methodName = method.getName();
                Class<?>[] paramTypes = method.getParameterTypes();
                Class<?> returnType = method.getReturnType();
                for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
                    mv.visitVarInsn(25, 3);
                    mv.visitIntInsn(16, paramIndex);
                    mv.visitInsn(50);
                    Type type = Type.getType(paramTypes[paramIndex]);
                    AsmBuilder.insertUnbox(mv, type);
                    buffer.append(type.getDescriptor());
                }
                buffer.append(')');
                buffer.append(Type.getDescriptor(returnType));
                int opcode = isInterface ? 185 : (isStatic ? 184 : (method.isPrivate() || method.isFinal() ? 183 : 182));
                mv.visitMethodInsn(opcode, this.delegateKlassNameInternal, methodName, buffer.toString(), isInterface);
                AsmBuilder.insertBox(mv, Type.getType(returnType));
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        AsmBuilder.throwIllegalArgumentException(mv, "wrong offset of method");
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void insertGetField(List<FieldInfo> fields) {
        MethodVisitor mv = this.cw.visitMethod(1, "getField", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        int n = fields.size();
        if (n != 0) {
            mv.visitVarInsn(21, 2);
            Label[] labels = new Label[n];
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            for (int i = 0; i < n; ++i) {
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                FieldInfo field = fields.get(i);
                Type type = Type.getType(field.getType());
                if (Modifier.isStatic(field.getModifiers())) {
                    mv.visitFieldInsn(178, this.delegateKlassNameInternal, field.getName(), type.getDescriptor());
                } else {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, this.delegateKlassNameInternal);
                    mv.visitFieldInsn(180, this.delegateKlassNameInternal, field.getName(), type.getDescriptor());
                }
                AsmBuilder.insertBox(mv, type);
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        AsmBuilder.throwIllegalArgumentException(mv, "wrong offset of field");
        int maxStack = fields.isEmpty() ? 5 : 6;
        mv.visitMaxs(maxStack, 3);
        mv.visitEnd();
    }

    public void insertSetField(List<FieldInfo> fields) {
        MethodVisitor mv = this.cw.visitMethod(1, "setField", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        mv.visitCode();
        int n = fields.size();
        if (n != 0) {
            mv.visitVarInsn(21, 2);
            Label[] labels = new Label[n];
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            for (int i = 0; i < n; ++i) {
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                FieldInfo field = fields.get(i);
                Type type = Type.getType(field.getType());
                boolean isStatic = Modifier.isStatic(field.getModifiers());
                if (!isStatic) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, this.delegateKlassNameInternal);
                }
                mv.visitVarInsn(25, 3);
                AsmBuilder.insertUnbox(mv, type);
                mv.visitFieldInsn(isStatic ? 179 : 181, this.delegateKlassNameInternal, field.getName(), type.getDescriptor());
                mv.visitInsn(177);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        AsmBuilder.throwIllegalArgumentException(mv, "wrong offset of field");
        int maxStack = fields.isEmpty() ? 5 : 6;
        mv.visitMaxs(maxStack, 4);
        mv.visitEnd();
    }

    private static void throwIllegalArgumentException(MethodVisitor mv, String message) {
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitLdcInsn(message);
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        mv.visitInsn(191);
    }

    private static void insertBox(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 0: {
                mv.visitInsn(1);
                break;
            }
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            }
        }
    }

    private static void insertUnbox(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B", false);
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S", false);
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F", false);
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "longValue", "()J", false);
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
                break;
            }
            case 9: {
                mv.visitTypeInsn(192, type.getDescriptor());
                break;
            }
            case 10: {
                String internalName = type.getInternalName();
                if ("java/lang/Object".equals(internalName)) break;
                mv.visitTypeInsn(192, internalName);
            }
        }
    }

    public byte[] asByteCode() {
        this.cw.visitEnd();
        return this.cw.toByteArray();
    }
}

