/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.time.Instant;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.DateConvertor;

public final class InstantConvertor
implements Convertor<Instant> {
    public static final InstantConvertor INSTANCE = new InstantConvertor();

    @Override
    public Instant convert(String value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(DateConvertor.toMilliseconds(value, Instant.class));
    }

    @Override
    public Instant convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        return Instant.ofEpochMilli(DateConvertor.toMilliseconds(value, Instant.class));
    }
}

